/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.builder;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.AggregationMetrics;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.OperatorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MergingHashAggregationBuilder
implements Closeable {
    private final List<AggregatorFactory> aggregatorFactories;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final List<Integer> groupByPartialChannels;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private final WorkProcessor<Page> sortedPages;
    private InMemoryHashAggregationBuilder hashAggregationBuilder;
    private final List<Type> groupByTypes;
    private final LocalMemoryContext memoryContext;
    private final long memoryLimitForMerge;
    private final int overwriteIntermediateChannelOffset;
    private final FlatHashStrategyCompiler hashStrategyCompiler;
    private final AggregationMetrics aggregationMetrics;

    public MergingHashAggregationBuilder(List<AggregatorFactory> aggregatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, Optional<Integer> hashChannel, OperatorContext operatorContext, WorkProcessor<Page> sortedPages, AggregatedMemoryContext aggregatedMemoryContext, long memoryLimitForMerge, int overwriteIntermediateChannelOffset, FlatHashStrategyCompiler hashStrategyCompiler, AggregationMetrics aggregationMetrics) {
        ImmutableList.Builder groupByPartialChannels = ImmutableList.builderWithExpectedSize((int)groupByTypes.size());
        for (int i = 0; i < groupByTypes.size(); ++i) {
            groupByPartialChannels.add((Object)i);
        }
        this.aggregatorFactories = aggregatorFactories;
        this.step = AggregationNode.Step.partialInput(step);
        this.expectedGroups = expectedGroups;
        this.groupByPartialChannels = groupByPartialChannels.build();
        this.hashChannel = hashChannel.isPresent() ? Optional.of(groupByTypes.size()) : hashChannel;
        this.operatorContext = operatorContext;
        this.sortedPages = sortedPages;
        this.groupByTypes = groupByTypes;
        this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(MergingHashAggregationBuilder.class.getSimpleName());
        this.memoryLimitForMerge = memoryLimitForMerge;
        this.overwriteIntermediateChannelOffset = overwriteIntermediateChannelOffset;
        this.hashStrategyCompiler = hashStrategyCompiler;
        this.aggregationMetrics = Objects.requireNonNull(aggregationMetrics, "aggregationMetrics is null");
        this.rebuildHashAggregationBuilder();
    }

    public WorkProcessor<Page> buildResult() {
        return this.sortedPages.flatTransform(new WorkProcessor.Transformation<Page, WorkProcessor<Page>>(){
            private boolean reset = true;
            private long memorySize;

            @Override
            public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Page inputPage) {
                boolean inputFinished;
                if (this.reset) {
                    MergingHashAggregationBuilder.this.rebuildHashAggregationBuilder();
                    this.memorySize = 0L;
                    this.reset = false;
                }
                boolean bl = inputFinished = inputPage == null;
                if (inputFinished && this.memorySize == 0L) {
                    return WorkProcessor.TransformationState.finished();
                }
                if (!inputFinished) {
                    boolean done = MergingHashAggregationBuilder.this.hashAggregationBuilder.processPage(inputPage).process();
                    Verify.verify((boolean)done);
                    this.memorySize = MergingHashAggregationBuilder.this.hashAggregationBuilder.getSizeInMemory();
                    MergingHashAggregationBuilder.this.memoryContext.setBytes(this.memorySize);
                    if (!MergingHashAggregationBuilder.this.shouldProduceOutput(this.memorySize)) {
                        return WorkProcessor.TransformationState.needsMoreData();
                    }
                }
                this.reset = true;
                return WorkProcessor.TransformationState.ofResult(MergingHashAggregationBuilder.this.hashAggregationBuilder.buildResult(), !inputFinished);
            }
        });
    }

    @Override
    public void close() {
        this.hashAggregationBuilder.close();
    }

    private boolean shouldProduceOutput(long memorySize) {
        return this.memoryLimitForMerge > 0L && memorySize > this.memoryLimitForMerge;
    }

    private void rebuildHashAggregationBuilder() {
        this.hashAggregationBuilder = new InMemoryHashAggregationBuilder(this.aggregatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByPartialChannels, this.hashChannel, false, this.operatorContext, Optional.of(DataSize.succinctBytes((long)0L)), Optional.of(this.overwriteIntermediateChannelOffset), this.hashStrategyCompiler, () -> true, this.aggregationMetrics);
    }
}

