/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;

@AggregationFunction(value="histogram")
@Description(value="Count the number of times each value occurs")
public final class Histogram {
    private Histogram() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState(value={"T"}) HistogramState state, @BlockPosition @SqlType(value="T") ValueBlock key, @BlockIndex int position) {
        state.add(key, position, 1L);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"T"}) HistogramState state, @AggregationState(value={"T"}) HistogramState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="map(T, BIGINT)")
    public static void output(@TypeParameter(value="T") Type type, @AggregationState(value={"T"}) HistogramState state, BlockBuilder out) {
        state.writeAll((MapBlockBuilder)out);
    }
}

