/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.airlift.stats.TDigest;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.TDigestState;
import io.trino.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class TDigestStateFactory
implements AccumulatorStateFactory<TDigestState> {
    public TDigestState createSingleState() {
        return new SingleTDigestState();
    }

    public TDigestState createGroupedState() {
        return new GroupedTDigestState();
    }

    public static class SingleTDigestState
    implements TDigestState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleTDigestState.class);
        private TDigest digest;

        @Override
        public TDigest getTDigest() {
            return this.digest;
        }

        @Override
        public void setTDigest(TDigest value) {
            this.digest = value;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += (long)this.digest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedTDigestState
    extends AbstractGroupedAccumulatorState
    implements TDigestState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedTDigestState.class);
        private final ObjectBigArray<TDigest> digests = new ObjectBigArray();
        private long size;

        public void ensureCapacity(int size) {
            this.digests.ensureCapacity((long)size);
        }

        @Override
        public TDigest getTDigest() {
            return (TDigest)this.digests.get((long)this.getGroupId());
        }

        @Override
        public void setTDigest(TDigest value) {
            Objects.requireNonNull(value, "value is null");
            this.digests.set((long)this.getGroupId(), (Object)value);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf();
        }
    }
}

