/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.chrono.ISOChronology;

@ScalarFunction
@Description(value="Formats the given timestamp by the given format")
public final class DateFormat {
    private DateFormat() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        timestamp = DateTimes.epochMicrosToMillisWithRounding(timestamp);
        return DateTimeFunctions.dateFormat(ISOChronology.getInstanceUTC(), session.getLocale(), timestamp, formatString);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return DateFormat.format(session, timestamp.getEpochMicros(), formatString);
    }
}

