/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.operator.scalar.json.ParameterUtil;
import io.trino.operator.table.json.JsonTablePlanNode;
import io.trino.operator.table.json.execution.ExecutionPlanner;
import io.trino.operator.table.json.execution.JsonTableProcessingFragment;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.type.Json2016Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class JsonTable {
    private JsonTable() {
    }

    public static TableFunctionProcessorProvider getJsonTableFunctionProcessorProvider(final Metadata metadata, final TypeManager typeManager, final FunctionManager functionManager) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                JsonTableFunctionHandle jsonTableFunctionHandle = (JsonTableFunctionHandle)handle;
                Object[] newRow = new Object[jsonTableFunctionHandle.outputTypes().length];
                JsonTableProcessingFragment executionPlan = ExecutionPlanner.getExecutionPlan(jsonTableFunctionHandle.processingPlan(), newRow, jsonTableFunctionHandle.errorOnError(), jsonTableFunctionHandle.outputTypes(), session, metadata, typeManager, functionManager);
                return new JsonTableFunctionProcessor(executionPlan, newRow, jsonTableFunctionHandle.outputTypes(), (RowType)jsonTableFunctionHandle.parametersType(), jsonTableFunctionHandle.outer());
            }
        };
    }

    public static class JsonTableFunctionProcessor
    implements TableFunctionDataProcessor {
        private final Type[] outputTypes;
        private final PageBuilder pageBuilder;
        private final JsonTableProcessingFragment executionPlan;
        private final Object[] newRow;
        private final RowType parametersType;
        private final boolean outer;
        private long totalPositionsProcessed;
        private int currentPosition = -1;
        private boolean currentPositionAlreadyProduced;

        public JsonTableFunctionProcessor(JsonTableProcessingFragment executionPlan, Object[] newRow, Type[] outputTypes, RowType parametersType, boolean outer) {
            this.outputTypes = Objects.requireNonNull(outputTypes, "outputTypes is null");
            this.pageBuilder = new PageBuilder((List)ImmutableList.builder().add((Object[])outputTypes).add((Object)BigintType.BIGINT).build());
            this.executionPlan = Objects.requireNonNull(executionPlan, "executionPlan is null");
            this.newRow = Objects.requireNonNull(newRow, "newRow is null");
            this.parametersType = Objects.requireNonNull(parametersType, "parametersType is null");
            this.outer = outer;
        }

        public TableFunctionProcessorState process(List<Optional<Page>> input) {
            if (input == null) {
                if (this.pageBuilder.isEmpty()) {
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                return this.flushPageBuilder();
            }
            Page inputPage = (Page)((Optional)Iterables.getOnlyElement(input)).orElseThrow();
            while (!this.pageBuilder.isFull()) {
                boolean gotNewRow;
                if (this.currentPosition == -1) {
                    if (inputPage.getPositionCount() == 0) {
                        return TableFunctionProcessorState.Processed.usedInput();
                    }
                    this.currentPosition = 0;
                    this.currentPositionAlreadyProduced = false;
                    ++this.totalPositionsProcessed;
                    SqlRow parametersRow = (SqlRow)TypeUtils.readNativeValue((Type)this.parametersType, (Block)inputPage.getBlock(1), (int)this.currentPosition);
                    this.executionPlan.resetRoot((JsonNode)TypeUtils.readNativeValue((Type)Json2016Type.JSON_2016, (Block)inputPage.getBlock(0), (int)this.currentPosition), inputPage, this.currentPosition, ParameterUtil.getParametersArray((Type)this.parametersType, parametersRow));
                }
                if (gotNewRow = this.executionPlan.getRow()) {
                    this.currentPositionAlreadyProduced = true;
                    this.addOutputRow();
                    continue;
                }
                if (this.outer && !this.currentPositionAlreadyProduced) {
                    this.addNullPaddedRow();
                }
                ++this.currentPosition;
                if (this.currentPosition < inputPage.getPositionCount()) {
                    this.currentPositionAlreadyProduced = false;
                    ++this.totalPositionsProcessed;
                    SqlRow parametersRow = (SqlRow)TypeUtils.readNativeValue((Type)this.parametersType, (Block)inputPage.getBlock(1), (int)this.currentPosition);
                    this.executionPlan.resetRoot((JsonNode)TypeUtils.readNativeValue((Type)Json2016Type.JSON_2016, (Block)inputPage.getBlock(0), (int)this.currentPosition), inputPage, this.currentPosition, ParameterUtil.getParametersArray((Type)this.parametersType, parametersRow));
                    continue;
                }
                this.currentPosition = -1;
                return TableFunctionProcessorState.Processed.usedInput();
            }
            return this.flushPageBuilder();
        }

        private TableFunctionProcessorState flushPageBuilder() {
            TableFunctionProcessorState.Processed result = TableFunctionProcessorState.Processed.produced((Page)this.pageBuilder.build());
            this.pageBuilder.reset();
            return result;
        }

        private void addOutputRow() {
            this.pageBuilder.declarePosition();
            for (int channel = 0; channel < this.outputTypes.length; ++channel) {
                TypeUtils.writeNativeValue((Type)this.outputTypes[channel], (BlockBuilder)this.pageBuilder.getBlockBuilder(channel), (Object)this.newRow[channel]);
            }
            BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(this.outputTypes.length), this.totalPositionsProcessed - 1L);
        }

        private void addNullPaddedRow() {
            Arrays.fill(this.newRow, null);
            this.addOutputRow();
        }
    }

    public record JsonTableFunctionHandle(JsonTablePlanNode processingPlan, boolean outer, boolean errorOnError, Type parametersType, Type[] outputTypes) implements ConnectorTableFunctionHandle
    {
        public JsonTableFunctionHandle {
            Objects.requireNonNull(processingPlan, "processingPlan is null");
            Objects.requireNonNull(parametersType, "parametersType is null");
            Objects.requireNonNull(outputTypes, "outputTypes is null");
            Preconditions.checkArgument((boolean)(parametersType instanceof RowType), (Object)"parametersType is not a row type");
        }
    }
}

