/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.trino.failuredetector.HeartbeatFailureDetector;
import io.trino.server.security.ResourceSecurity;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;

@Path(value="/v1/node")
@ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_READ)
public class NodeResource {
    private final HeartbeatFailureDetector failureDetector;

    @Inject
    public NodeResource(HeartbeatFailureDetector failureDetector) {
        this.failureDetector = failureDetector;
    }

    @GET
    public Collection<HeartbeatFailureDetector.Stats> getNodeStats() {
        return this.failureDetector.getStats().values();
    }

    @GET
    @Path(value="failed")
    public Collection<HeartbeatFailureDetector.Stats> getFailed() {
        return Maps.filterKeys(this.failureDetector.getStats(), (Predicate)Predicates.in(this.failureDetector.getFailed())).values();
    }
}

