/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.SpoolingEnabledConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class QueryDataEncoders {
    private static final Logger LOG = Logger.get(QueryDataEncoders.class);
    private final Map<String, QueryDataEncoder.Factory> factories;
    private final boolean enabled;

    @Inject
    public QueryDataEncoders(SpoolingEnabledConfig enabledConfig, Set<QueryDataEncoder.Factory> factories) {
        this.enabled = enabledConfig.isEnabled();
        this.factories = (Map)Objects.requireNonNull(factories, "factories is null").stream().map(factory -> Map.entry(factory.encoding(), factory)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.enabled) {
            LOG.info("Spooling protocol is enabled with encodings: %s", new Object[]{this.getAvailableEncodings()});
        }
    }

    public boolean exists(String encoding) {
        if (!this.enabled) {
            throw new IllegalStateException("Spooling protocol is not enabled");
        }
        return this.factories.containsKey(encoding);
    }

    public QueryDataEncoder.Factory get(String encoding) {
        if (!this.enabled) {
            throw new IllegalStateException("Spooling protocol is not enabled");
        }
        if (!this.exists(encoding)) {
            throw new IllegalArgumentException("Unknown spooling protocol encoding: " + encoding);
        }
        return this.factories.get(encoding);
    }

    public Set<String> getAvailableEncodings() {
        if (!this.enabled) {
            throw new IllegalStateException("Spooling protocol is not enabled");
        }
        return this.factories.keySet();
    }
}

