/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.client.spooling.DataAttributes;
import io.trino.server.protocol.spooling.SpooledMetadataBlockSerde;
import io.trino.spi.Page;
import io.trino.spi.spool.SpooledLocation;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public sealed interface SpooledMetadataBlock {
    public DataAttributes attributes();

    default public Page serialize() {
        return SpooledMetadataBlockSerde.serialize(this);
    }

    public static SpooledMetadataBlock forInlineData(DataAttributes attributes, byte[] data) {
        return new Inlined(attributes, Slices.wrappedBuffer((byte[])data));
    }

    public static SpooledMetadataBlock forSpooledLocation(SpooledLocation location, DataAttributes attributes) {
        SpooledLocation spooledLocation = location;
        Objects.requireNonNull(spooledLocation);
        SpooledLocation spooledLocation2 = spooledLocation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledLocation.DirectLocation.class, SpooledLocation.CoordinatorLocation.class}, (SpooledLocation)spooledLocation2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SpooledLocation.DirectLocation directLocation = (SpooledLocation.DirectLocation)spooledLocation2;
                yield new Spooled(attributes, directLocation.identifier(), Optional.of(directLocation.directUri()), directLocation.headers());
            }
            case 1 -> {
                SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)spooledLocation2;
                yield new Spooled(attributes, coordinatorLocation.identifier(), Optional.empty(), coordinatorLocation.headers());
            }
        };
    }

    public record Inlined(DataAttributes attributes, Slice data) implements SpooledMetadataBlock
    {
        public Inlined {
            Objects.requireNonNull(attributes, "attributes is null");
            Objects.requireNonNull(data, "data is null");
        }
    }

    public record Spooled(DataAttributes attributes, Slice identifier, Optional<URI> directUri, Map<String, List<String>> headers) implements SpooledMetadataBlock
    {
        public Spooled {
            Objects.requireNonNull(attributes, "attributes is null");
            Objects.requireNonNull(identifier, "identifier is null");
            Objects.requireNonNull(directUri, "directUri is null");
            Objects.requireNonNull(headers, "headers is null");
        }
    }
}

