/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import com.google.inject.Inject;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.trino.client.NodeVersion;
import io.trino.server.security.ResourceSecurity;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;

@Path(value="/ui/api/cluster")
@ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
public class ClusterResource {
    private final NodeVersion version;
    private final String environment;
    private final long startTime = System.nanoTime();

    @Inject
    public ClusterResource(NodeVersion nodeVersion, NodeInfo nodeInfo) {
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = nodeInfo.getEnvironment();
    }

    @GET
    @Produces(value={"application/json"})
    public ClusterInfo getInfo() {
        return new ClusterInfo(this.version, this.environment, Duration.nanosSince((long)this.startTime));
    }

    @Immutable
    public static class ClusterInfo {
        private final NodeVersion nodeVersion;
        private final String environment;
        private final Duration uptime;

        public ClusterInfo(NodeVersion nodeVersion, String environment, Duration uptime) {
            this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
            this.environment = Objects.requireNonNull(environment, "environment is null");
            this.uptime = Objects.requireNonNull(uptime, "uptime is null");
        }

        @JsonProperty
        public NodeVersion getNodeVersion() {
            return this.nodeVersion;
        }

        @JsonProperty
        public String getEnvironment() {
            return this.environment;
        }

        @JsonProperty
        public Duration getUptime() {
            return this.uptime;
        }
    }
}

