/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.FunctionResolver;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.FreeLambdaReferenceExtractor;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.ScopeReferenceExtractor;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class AggregationAnalyzer {
    private final Set<FieldId> groupingFields;
    private final Set<ScopeAware<Expression>> expressions;
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences;
    private final Session session;
    private final Analysis analysis;
    private final FunctionResolver functionResolver;
    private final AccessControl accessControl;
    private final Scope sourceScope;
    private final Optional<Scope> orderByScope;

    public static void verifySourceAggregations(List<Expression> groupByExpressions, Scope sourceScope, List<Expression> expressions, Session session, PlannerContext plannerContext, AccessControl accessControl, Analysis analysis) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.empty(), session, plannerContext, accessControl, analysis);
        for (Expression expression : expressions) {
            analyzer.analyze(expression);
        }
    }

    public static void verifyOrderByAggregations(List<Expression> groupByExpressions, Scope sourceScope, Scope orderByScope, List<Expression> expressions, Session session, PlannerContext plannerContext, AccessControl accessControl, Analysis analysis) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.of(orderByScope), session, plannerContext, accessControl, analysis);
        for (Expression expression : expressions) {
            analyzer.analyze(expression);
        }
    }

    private AggregationAnalyzer(List<Expression> groupByExpressions, Scope sourceScope, Optional<Scope> orderByScope, Session session, PlannerContext plannerContext, AccessControl accessControl, Analysis analysis) {
        Objects.requireNonNull(groupByExpressions, "groupByExpressions is null");
        Objects.requireNonNull(sourceScope, "sourceScope is null");
        Objects.requireNonNull(orderByScope, "orderByScope is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(plannerContext, "metadata is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        Objects.requireNonNull(analysis, "analysis is null");
        this.sourceScope = sourceScope;
        this.orderByScope = orderByScope;
        this.session = session;
        this.analysis = analysis;
        this.accessControl = accessControl;
        this.expressions = (Set)groupByExpressions.stream().map(expression -> ScopeAware.scopeAwareKey(expression, analysis, sourceScope)).collect(ImmutableSet.toImmutableSet());
        this.functionResolver = plannerContext.getFunctionResolver();
        this.columnReferences = analysis.getColumnReferenceFields();
        this.groupingFields = (Set)groupByExpressions.stream().map(NodeRef::of).filter(this.columnReferences::containsKey).map(this.columnReferences::get).map(ResolvedField::getFieldId).collect(ImmutableSet.toImmutableSet());
        this.groupingFields.forEach(fieldId -> Preconditions.checkState((boolean)ScopeReferenceExtractor.isFieldFromScope(fieldId, sourceScope), (String)"Grouping field %s should originate from %s", (Object)fieldId, (Object)sourceScope.getRelationType()));
    }

    private void analyze(Expression expression) {
        Visitor visitor = new Visitor();
        if (!visitor.process((Node)expression, null).booleanValue()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "'%s' must be an aggregate expression or appear in GROUP BY clause", expression);
        }
    }

    private boolean hasOrderByReferencesToOutputColumns(Node node) {
        return ScopeReferenceExtractor.hasReferencesToScope(node, this.analysis, this.orderByScope.get());
    }

    private void verifyNoOrderByReferencesToOutputColumns(Node node, StandardErrorCode errorCode, String errorString) {
        ScopeReferenceExtractor.getReferencesToScope(node, this.analysis, this.orderByScope.get()).findFirst().ifPresent(expression -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)errorCode, (Node)expression, "%s", errorString);
        });
    }

    private class Visitor
    extends AstVisitor<Boolean, Void> {
        private Visitor() {
        }

        protected Boolean visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("aggregation analysis not yet implemented for: " + node.getClass().getName());
        }

        protected Boolean visitAtTimeZone(AtTimeZone node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitSubqueryExpression(SubqueryExpression node, Void context) {
            ScopeReferenceExtractor.getReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope).filter(expression -> !this.isGroupingKey((Expression)expression)).findFirst().ifPresent(expression -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "Subquery uses '%s' which must appear in GROUP BY clause", expression);
            });
            return true;
        }

        protected Boolean visitExists(ExistsPredicate node, Void context) {
            Preconditions.checkState((boolean)(node.getSubquery() instanceof SubqueryExpression));
            return this.process((Node)node.getSubquery(), context);
        }

        protected Boolean visitSubscriptExpression(SubscriptExpression node, Void context) {
            return this.process((Node)node.getBase(), context) != false && this.process((Node)node.getIndex(), context) != false;
        }

        protected Boolean visitArray(Array node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitCast(Cast node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
            return node.getOperands().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
            return this.process((Node)node.getFirst(), context) != false && this.process((Node)node.getSecond(), context) != false;
        }

        protected Boolean visitExtract(Extract node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
            return this.process((Node)node.getMin(), context) != false && this.process((Node)node.getValue(), context) != false && this.process((Node)node.getMax(), context) != false;
        }

        protected Boolean visitCurrentTime(CurrentTime node, Void context) {
            return true;
        }

        protected Boolean visitCurrentDate(CurrentDate node, Void context) {
            return true;
        }

        protected Boolean visitCurrentTimestamp(CurrentTimestamp node, Void context) {
            return true;
        }

        protected Boolean visitLocalTime(LocalTime node, Void context) {
            return true;
        }

        protected Boolean visitLocalTimestamp(LocalTimestamp node, Void context) {
            return true;
        }

        protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        protected Boolean visitLiteral(Literal node, Void context) {
            return true;
        }

        protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLikePredicate(LikePredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getPattern(), context) != false;
        }

        protected Boolean visitInListExpression(InListExpression node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitInPredicate(InPredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getValueList(), context) != false;
        }

        protected Boolean visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getSubquery(), context) != false;
        }

        protected Boolean visitTrim(Trim node, Void context) {
            return this.process((Node)node.getTrimSource(), context) != false && (node.getTrimCharacter().isEmpty() || this.process((Node)node.getTrimCharacter().get(), context) != false);
        }

        protected Boolean visitFormat(Format node, Void context) {
            return node.getArguments().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitFunctionCall(FunctionCall node, Void context) {
            WindowSpecification windowSpecification;
            Window window;
            if (AggregationAnalyzer.this.functionResolver.isAggregationFunction(AggregationAnalyzer.this.session, node.getName(), AggregationAnalyzer.this.accessControl)) {
                if (node.getWindow().isEmpty()) {
                    List<FunctionCall> aggregateFunctions = ExpressionTreeUtils.extractAggregateFunctions(node.getArguments(), AggregationAnalyzer.this.session, AggregationAnalyzer.this.functionResolver, AggregationAnalyzer.this.accessControl);
                    List<Expression> windowExpressions = ExpressionTreeUtils.extractWindowExpressions(node.getArguments());
                    if (!aggregateFunctions.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_AGGREGATION, (Node)node, "Cannot nest aggregations inside aggregation '%s': %s", node.getName(), aggregateFunctions);
                    }
                    if (!windowExpressions.isEmpty()) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions or row pattern measures inside aggregation '%s': %s", node.getName(), windowExpressions);
                    }
                    if (node.getOrderBy().isPresent()) {
                        List sortKeys = (List)((OrderBy)node.getOrderBy().get()).getSortItems().stream().map(SortItem::getSortKey).collect(ImmutableList.toImmutableList());
                        if (node.isDistinct()) {
                            List fieldIds = (List)node.getArguments().stream().map(NodeRef::of).map(AggregationAnalyzer.this.columnReferences::get).filter(Objects::nonNull).map(ResolvedField::getFieldId).collect(ImmutableList.toImmutableList());
                            for (Expression sortKey : sortKeys) {
                                ResolvedField field;
                                if (node.getArguments().contains(sortKey) || (field = AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)sortKey))) != null && fieldIds.contains(field.getFieldId())) continue;
                                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT, (Node)sortKey, "For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments", new Object[0]);
                            }
                        }
                        if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                            for (Expression sortKey : sortKeys) {
                                AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)sortKey, StandardErrorCode.COLUMN_NOT_FOUND, "ORDER BY clause in aggregation function must not reference query output columns");
                            }
                        }
                    }
                    if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                        node.getArguments().forEach(argument -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)argument, StandardErrorCode.COLUMN_NOT_FOUND, "Invalid reference to output projection attribute from ORDER BY aggregation"));
                        node.getFilter().ifPresent(expression -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)expression, StandardErrorCode.COLUMN_NOT_FOUND, "Invalid reference to output projection attribute from ORDER BY aggregation"));
                    }
                    return true;
                }
            } else {
                if (node.getFilter().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE, (Node)node, "Filter is only valid for aggregation functions", new Object[0]);
                }
                if (node.getOrderBy().isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_AGGREGATE, (Node)node, "ORDER BY is only valid for aggregation functions", new Object[0]);
                }
            }
            if (node.getWindow().isPresent() && (window = (Window)node.getWindow().get()) instanceof WindowSpecification && !this.process((Node)(windowSpecification = (WindowSpecification)window), context).booleanValue()) {
                return false;
            }
            return node.getArguments().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitWindowOperation(WindowOperation node, Void context) {
            return node.getWindow() instanceof WindowReference || this.process((Node)((WindowSpecification)node.getWindow()), context) != false;
        }

        protected Boolean visitLambdaExpression(LambdaExpression node, Void context) {
            return this.process((Node)node.getBody(), context);
        }

        protected Boolean visitWindowSpecification(WindowSpecification node, Void context) {
            for (Expression expression : node.getPartitionBy()) {
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "PARTITION BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(node.getOrderBy())) {
                Expression expression = sortItem.getSortKey();
                if (this.process((Node)expression, context).booleanValue()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)expression, "ORDER BY expression '%s' must be an aggregate expression or appear in GROUP BY clause", expression);
            }
            if (node.getFrame().isPresent()) {
                this.process((Node)node.getFrame().get(), context);
            }
            return true;
        }

        protected Boolean visitWindowFrame(WindowFrame node, Void context) {
            Expression endValue;
            Optional start = node.getStart().getValue();
            if (start.isPresent() && !this.process((Node)start.get(), context).booleanValue()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)start.get(), "Window frame start must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            if (node.getEnd().isPresent() && ((FrameBound)node.getEnd().get()).getValue().isPresent() && !this.process((Node)(endValue = (Expression)((FrameBound)node.getEnd().get()).getValue().get()), context).booleanValue()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)endValue, "Window frame end must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            for (MeasureDefinition measure : node.getMeasures()) {
                if (this.process((Node)measure.getExpression(), context).booleanValue()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)measure, "Row pattern measure must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            for (VariableDefinition variableDefinition : node.getVariableDefinitions()) {
                if (this.process((Node)variableDefinition.getExpression(), context).booleanValue()) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)variableDefinition, "Row pattern variable definition must be an aggregate expression or appear in GROUP BY clause", new Object[0]);
            }
            return true;
        }

        protected Boolean visitIdentifier(Identifier node, Void context) {
            if (AggregationAnalyzer.this.analysis.getLambdaArgumentReferences().containsKey(NodeRef.of((Node)node))) {
                return true;
            }
            if (!ScopeReferenceExtractor.hasReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) {
                return true;
            }
            return this.isGroupingKey((Expression)node);
        }

        protected Boolean visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (!ScopeReferenceExtractor.hasReferencesToScope((Node)node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) {
                return true;
            }
            if (AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)node))) {
                return this.isGroupingKey((Expression)node);
            }
            return this.process((Node)node.getBase(), context);
        }

        private boolean isGroupingKey(Expression node) {
            FieldId fieldId = Objects.requireNonNull(AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)node)), () -> "No field for " + String.valueOf(node)).getFieldId();
            if (AggregationAnalyzer.this.orderByScope.isPresent() && ScopeReferenceExtractor.isFieldFromScope(fieldId, AggregationAnalyzer.this.orderByScope.get())) {
                return true;
            }
            return AggregationAnalyzer.this.groupingFields.contains(fieldId);
        }

        protected Boolean visitFieldReference(FieldReference node, Void context) {
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                return true;
            }
            FieldId fieldId = Objects.requireNonNull(AggregationAnalyzer.this.columnReferences.get(NodeRef.of((Node)node)), () -> "No field for " + String.valueOf(node)).getFieldId();
            boolean inGroup = AggregationAnalyzer.this.groupingFields.contains(fieldId);
            if (!inGroup) {
                Field field = AggregationAnalyzer.this.sourceScope.getRelationType().getFieldByIndex(node.getFieldIndex());
                Object column = field.getName().isEmpty() ? Integer.toString(node.getFieldIndex() + 1) : (field.getRelationAlias().isPresent() ? String.format("'%s.%s'", field.getRelationAlias().get(), field.getName().get()) : "'" + field.getName().get() + "'");
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_AGGREGATE, (Node)node, "Column %s not in GROUP BY clause", column);
            }
            return inGroup;
        }

        protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitNotExpression(NotExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Boolean visitLogicalExpression(LogicalExpression node, Void context) {
            return node.getTerms().stream().allMatch(item -> this.process((Node)item, context));
        }

        protected Boolean visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder expressions = ImmutableList.builder().add((Object)node.getCondition()).add((Object)node.getTrueValue());
            if (node.getFalseValue().isPresent()) {
                expressions.add((Object)((Expression)node.getFalseValue().get()));
            }
            return expressions.build().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            if (!this.process((Node)node.getOperand(), context).booleanValue()) {
                return false;
            }
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return node.getDefaultValue().isEmpty() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return node.getDefaultValue().isEmpty() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        protected Boolean visitTryExpression(TryExpression node, Void context) {
            return this.process((Node)node.getInnerExpression(), context);
        }

        protected Boolean visitRow(Row node, Void context) {
            return node.getItems().stream().allMatch(item -> this.process((Node)item, context));
        }

        protected Boolean visitParameter(Parameter node, Void context) {
            if (AggregationAnalyzer.this.analysis.isDescribe()) {
                return true;
            }
            Map<NodeRef<Parameter>, Expression> parameters = AggregationAnalyzer.this.analysis.getParameters();
            Preconditions.checkArgument((node.getId() < parameters.size() ? 1 : 0) != 0, (String)"Invalid parameter number %s, max values is %s", (int)node.getId(), (int)(parameters.size() - 1));
            return this.process((Node)parameters.get(NodeRef.of((Node)node)), context);
        }

        protected Boolean visitGroupingOperation(GroupingOperation node, Void context) {
            Optional<Expression> argumentNotInGroupBy;
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                node.getGroupingColumns().forEach(groupingColumn -> AggregationAnalyzer.this.verifyNoOrderByReferencesToOutputColumns((Node)groupingColumn, StandardErrorCode.INVALID_ARGUMENTS, "Invalid reference to output of SELECT clause from grouping() expression in ORDER BY"));
            }
            if ((argumentNotInGroupBy = node.getGroupingColumns().stream().filter(argument -> !AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of((Node)argument)) || !this.isGroupingKey((Expression)argument)).findAny()).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)node, "The arguments to GROUPING() must be expressions referenced by the GROUP BY at the associated query level. Mismatch due to %s.", argumentNotInGroupBy.get());
            }
            return true;
        }

        protected Boolean visitJsonExists(JsonExists node, Void context) {
            return this.process((Node)node.getJsonPathInvocation(), context);
        }

        protected Boolean visitJsonValue(JsonValue node, Void context) {
            return this.process((Node)node.getJsonPathInvocation(), context) != false && node.getEmptyDefault().map(expression -> this.process((Node)expression, context)).orElse(true) != false && node.getErrorDefault().map(expression -> this.process((Node)expression, context)).orElse(true) != false;
        }

        protected Boolean visitJsonQuery(JsonQuery node, Void context) {
            return this.process((Node)node.getJsonPathInvocation(), context);
        }

        protected Boolean visitJsonPathInvocation(JsonPathInvocation node, Void context) {
            return this.process((Node)node.getInputExpression(), context) != false && node.getPathParameters().stream().map(JsonPathParameter::getParameter).allMatch(expression -> this.process((Node)expression, context));
        }

        protected Boolean visitJsonObject(JsonObject node, Void context) {
            return node.getMembers().stream().allMatch(member -> this.process((Node)member.getKey(), context) != false && this.process((Node)member.getValue(), context) != false);
        }

        protected Boolean visitJsonArray(JsonArray node, Void context) {
            return node.getElements().stream().allMatch(element -> this.process((Node)element.getValue(), context));
        }

        public Boolean process(Node node, @Nullable Void context) {
            if (node instanceof Expression && AggregationAnalyzer.this.expressions.contains(ScopeAware.scopeAwareKey(node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) && (AggregationAnalyzer.this.orderByScope.isEmpty() || !AggregationAnalyzer.this.hasOrderByReferencesToOutputColumns(node)) && !FreeLambdaReferenceExtractor.hasFreeReferencesToLambdaArgument(node, AggregationAnalyzer.this.analysis)) {
                return true;
            }
            return (Boolean)super.process(node, (Object)context);
        }
    }
}

