/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.control.WhileLoop;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.JumpInstruction;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.slice.Slice;
import io.trino.cache.CacheStatsMBean;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.metadata.FunctionManager;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.CursorProcessorOutput;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.LambdaBytecodeGenerator;
import io.trino.sql.gen.LambdaExpressionExtractor;
import io.trino.sql.gen.RowExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.util.CompilerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class CursorProcessorCompiler {
    private static final int MAX_PROJECTIONS_PER_CHUNK = 100;
    private final FunctionManager functionManager;
    private final NonEvictableLoadingCache<CacheKey, Class<? extends CursorProcessor>> cursorProcessors;
    private final CacheStatsMBean cacheStatsMBean;

    @Inject
    public CursorProcessorCompiler(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.cursorProcessors = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> this.compile(key.filter(), key.projections())));
        this.cacheStatsMBean = new CacheStatsMBean(this.cursorProcessors);
    }

    @Managed
    @Nested
    public CacheStatsMBean getCursorProcessorCache() {
        return this.cacheStatsMBean;
    }

    public Supplier<CursorProcessor> compileCursorProcessor(Optional<RowExpression> filter, List<RowExpression> projections, Object uniqueKey) {
        Class cursorProcessor;
        try {
            cursorProcessor = (Class)this.cursorProcessors.getUnchecked((Object)new CacheKey(filter, projections, uniqueKey));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
        return () -> {
            try {
                return (CursorProcessor)cursorProcessor.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Class<? extends CursorProcessor> compile(Optional<RowExpression> filter, List<RowExpression> projections) {
        return this.compileProcessor(filter.orElse(Expressions.constant(true, (Type)BooleanType.BOOLEAN)), projections);
    }

    private Class<? extends CursorProcessor> compileProcessor(RowExpression filter, List<RowExpression> projections) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ArrayList<CursorProcessorChunkClass> chunkClasses = new ArrayList<CursorProcessorChunkClass>();
        List partitions = Lists.partition(projections, (int)100);
        int projectionStartIndex = 0;
        for (List partition : partitions) {
            int chunkNumber = chunkClasses.size();
            CursorProcessorChunkClass chunkClass = this.generateCursorProcessorChunk(partition, projectionStartIndex, callSiteBinder, chunkNumber);
            chunkClasses.add(chunkClass);
            projectionStartIndex += partition.size();
        }
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(CursorProcessor.class.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(CursorProcessor.class)});
        this.generateMethods(classDefinition, callSiteBinder, filter, chunkClasses);
        CursorProcessorCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).add("projections", projections).toString());
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(this.getClass().getClassLoader(), callSiteBinder.getBindings());
        for (CursorProcessorChunkClass chunkClass : chunkClasses) {
            CompilerUtils.defineClass(chunkClass.classDefinition(), Object.class, dynamicClassLoader);
        }
        return CompilerUtils.defineClass(classDefinition, CursorProcessor.class, dynamicClassLoader);
    }

    private void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<CursorProcessorChunkClass> chunkClasses) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        CursorProcessorCompiler.generateProcessMethod(classDefinition, chunkClasses);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> filterCompiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, filter, "filter");
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, filterCompiledLambdaMap, filter);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        for (CursorProcessorChunkClass chunkClass : chunkClasses) {
            FieldDefinition chunkField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "chunk_" + chunkClass.chunkNumber(), chunkClass.classDefinition().getType());
            constructorBody.append((BytecodeNode)thisVariable.setField(chunkField, BytecodeExpressions.newInstance((ParameterizedType)chunkClass.classDefinition().getType(), (BytecodeExpression[])new BytecodeExpression[0])));
        }
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, List<CursorProcessorChunkClass> chunkClasses) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter yieldSignal = Parameter.arg((String)"yieldSignal", DriverYieldSignal.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(CursorProcessorOutput.class), new Parameter[]{session, yieldSignal, cursor, pageBuilder});
        Scope scope = method.getScope();
        Variable completedPositionsVariable = scope.declareVariable(Integer.TYPE, "completedPositions");
        Variable finishedVariable = scope.declareVariable(Boolean.TYPE, "finished");
        method.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0).comment("boolean finished = false;").putVariable(finishedVariable, false);
        LabelNode done = new LabelNode("done");
        WhileLoop whileLoop = new WhileLoop().condition((BytecodeNode)BytecodeExpressions.constantTrue()).body((BytecodeNode)new BytecodeBlock().comment("if (pageBuilder.isFull() || yieldSignal.isSet()) return new CursorProcessorOutput(completedPositions, false);").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)yieldSignal.invoke("isSet", Boolean.TYPE, new BytecodeExpression[0]))).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)done))).comment("if (!cursor.advanceNextPosition()) return new CursorProcessorOutput(completedPositions, true);").append((BytecodeNode)new IfStatement().condition((BytecodeNode)cursor.invoke("advanceNextPosition", Boolean.TYPE, new BytecodeExpression[0])).ifFalse((BytecodeNode)new BytecodeBlock().putVariable(finishedVariable, true).gotoLabel(done))).comment("do the projection").append((BytecodeNode)CursorProcessorCompiler.createProjectIfStatement(classDefinition, method, session, cursor, pageBuilder, chunkClasses)).comment("completedPositions++;").incrementVariable(completedPositionsVariable, (byte)1));
        method.getBody().append((BytecodeNode)whileLoop).visitLabel(done).append((BytecodeNode)BytecodeExpressions.newInstance(CursorProcessorOutput.class, (BytecodeExpression[])new BytecodeExpression[]{completedPositionsVariable, finishedVariable}).ret());
    }

    private static IfStatement createProjectIfStatement(ClassDefinition classDefinition, MethodDefinition method, Parameter session, Parameter cursor, Parameter pageBuilder, List<CursorProcessorChunkClass> chunkClasses) {
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append((BytecodeNode)method.getThis()).getVariable((Variable)session).getVariable((Variable)cursor).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), new ParameterizedType[]{ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class)});
        ifStatement.ifTrue().getVariable((Variable)pageBuilder).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (CursorProcessorChunkClass chunkClass : chunkClasses) {
            ifStatement.ifTrue().append((BytecodeNode)method.getThis().getField(classDefinition.getType(), "chunk_" + chunkClass.chunkNumber(), chunkClass.classDefinition().getType()).invoke(chunkClass.projectMethod(), (Iterable)ImmutableList.of((Object)session, (Object)cursor, (Object)pageBuilder)));
        }
        return ifStatement;
    }

    private CursorProcessorChunkClass generateCursorProcessorChunk(List<RowExpression> projections, int projectionStartIndex, CallSiteBinder callSiteBinder, int chunkNumber) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("CursorProcessorChunk"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, callSiteBinder);
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        MethodDefinition project = this.generateProjectChunk(definition, projectionStartIndex, callSiteBinder, cachedInstanceBinder, projections);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return new CursorProcessorChunkClass(definition, project, chunkNumber);
    }

    private MethodDefinition generateProjectChunk(ClassDefinition classDefinition, int projectionStartIndex, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, List<RowExpression> projections) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "project", ParameterizedType.type(Void.TYPE), new Parameter[]{session, cursor, pageBuilder});
        BytecodeBlock block = methodDefinition.getBody();
        int projectionIndex = projectionStartIndex;
        for (RowExpression projection : projections) {
            String methodName = "project_" + projectionIndex;
            Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> projectCompiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, projection, methodName);
            this.generateProjectMethod(classDefinition, callSiteBinder, cachedInstanceBinder, projectCompiledLambdaMap, methodName, projection);
            block.append((BytecodeNode)methodDefinition.getThis()).getVariable((Variable)session).getVariable((Variable)cursor);
            block.getVariable((Variable)pageBuilder).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, new Class[]{Integer.TYPE});
            block.invokeVirtual(classDefinition.getType(), methodName, ParameterizedType.type(Void.TYPE), new ParameterizedType[]{ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class)});
            ++projectionIndex;
        }
        block.ret();
        return methodDefinition;
    }

    private Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression projection, String methodPrefix) {
        ImmutableSet lambdaExpressions = ImmutableSet.copyOf(LambdaExpressionExtractor.extractLambdaExpressions(projection));
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            String methodName = methodPrefix + "_lambda_" + counter;
            LambdaBytecodeGenerator.CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, methodName, containerClassDefinition, (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.buildOrThrow(), callSiteBinder, cachedInstanceBinder, this.functionManager);
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return compiledLambdaMap.buildOrThrow();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, RowExpression filter) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), new Parameter[]{session, cursor});
        method.comment("Filter: %s", new Object[]{filter});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        RowExpressionCompiler compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.functionManager, compiledLambdaMap, (List<Parameter>)ImmutableList.of((Object)session, (Object)cursor));
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate filter: " + String.valueOf(filter)).append(compiler.compile(filter, scope)).comment("if (wasNull) return false;").getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, String methodName, RowExpression projection) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter output = Parameter.arg((String)"output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type(Void.TYPE), new Parameter[]{session, cursor, output});
        method.comment("Projection: %s", new Object[]{projection});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        RowExpressionCompiler compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.functionManager, compiledLambdaMap, (List<Parameter>)ImmutableList.of((Object)session, (Object)cursor, (Object)output));
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).getVariable((Variable)output).comment("evaluate projection: " + projection.toString()).append(compiler.compile(projection, scope)).append(BytecodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.type())).ret();
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(final Variable cursorVariable) {
        return new RowExpressionVisitor<BytecodeNode, Scope>(){

            @Override
            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.field();
                Type type = node.type();
                Variable wasNullVariable = scope.getVariable("wasNull");
                Class javaType = type.getJavaType();
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("cursor.get%s(%d)", type, field)).getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                ifStatement.ifFalse().getVariable(cursorVariable).push(field);
                if (javaType == Boolean.TYPE) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getBoolean", Boolean.TYPE, new Class[]{Integer.TYPE});
                } else if (javaType == Long.TYPE) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getLong", Long.TYPE, new Class[]{Integer.TYPE});
                } else if (javaType == Double.TYPE) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getDouble", Double.TYPE, new Class[]{Integer.TYPE});
                } else if (javaType == Slice.class) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getSlice", Slice.class, new Class[]{Integer.TYPE});
                } else {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getObject", Object.class, new Class[]{Integer.TYPE}).checkCast(javaType);
                }
                return ifStatement;
            }

            @Override
            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitSpecialForm(SpecialForm specialForm, Scope context) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString", new BytecodeExpression[0])).retObject();
    }

    private record CacheKey(Optional<RowExpression> filter, List<RowExpression> projections, Object uniqueKey) {
        CacheKey {
            projections = ImmutableList.copyOf((Collection)Objects.requireNonNull(projections, "projections is null"));
        }
    }

    private record CursorProcessorChunkClass(ClassDefinition classDefinition, MethodDefinition projectMethod, int chunkNumber) {
    }
}

