/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.Constant;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.sql.gen.Binding;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.type.FunctionType;
import io.trino.util.CompilerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class CallColumnarFilterGenerator {
    private final CallExpression callExpression;
    private final FunctionManager functionManager;

    public CallColumnarFilterGenerator(CallExpression callExpression, FunctionManager functionManager) {
        callExpression.arguments().forEach(rowExpression -> {
            ConstantExpression constant;
            if (!(rowExpression instanceof InputReferenceExpression) && !(rowExpression instanceof ConstantExpression)) {
                throw new UnsupportedOperationException("Call expression with unsupported argument: " + String.valueOf(rowExpression));
            }
            if (rowExpression instanceof ConstantExpression && (constant = (ConstantExpression)rowExpression).value() == null) {
                throw new UnsupportedOperationException("Call expressions with null constant are not supported");
            }
        });
        callExpression.resolvedFunction().signature().getArgumentTypes().forEach(type -> {
            if (type instanceof FunctionType) {
                throw new UnsupportedOperationException("Functions with lambda arguments are not supported");
            }
        });
        this.callExpression = callExpression;
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    public Supplier<ColumnarFilter> generateColumnarFilter() {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(ColumnarFilter.class.getSimpleName() + String.valueOf(this.callExpression.resolvedFunction().signature().getName()), Optional.empty()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(ColumnarFilter.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        ColumnarFilterCompiler.generateGetInputChannels(callSiteBinder, classDefinition, this.callExpression);
        this.generateFilterRangeMethod(classDefinition, callSiteBinder, cachedInstanceBinder);
        this.generateFilterListMethod(classDefinition, callSiteBinder, cachedInstanceBinder);
        CallColumnarFilterGenerator.generateConstructor(classDefinition, cachedInstanceBinder);
        return ColumnarFilterCompiler.createClassInstance(callSiteBinder, classDefinition);
    }

    private void generateFilterRangeMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter outputPositions = Parameter.arg((String)"outputPositions", int[].class);
        Parameter offset = Parameter.arg((String)"offset", Integer.TYPE);
        Parameter size = Parameter.arg((String)"size", Integer.TYPE);
        Parameter page = Parameter.arg((String)"page", SourcePage.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filterPositionsRange", ParameterizedType.type(Integer.TYPE), (Iterable)ImmutableList.of((Object)session, (Object)outputPositions, (Object)offset, (Object)size, (Object)page));
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        ColumnarFilterCompiler.declareBlockVariables(this.callExpression.arguments(), page, scope, body);
        Variable outputPositionsCount = scope.declareVariable("outputPositionsCount", body, BytecodeExpressions.constantInt((int)0));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        FunctionNullability functionNullability = this.callExpression.resolvedFunction().functionNullability();
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockMayHaveNull(this.callExpression.arguments(), functionNullability.getArgumentNullable(), scope));
        body.append((BytecodeNode)ifStatement);
        Function<MethodHandle, BytecodeNode> instance = instanceFactory -> scope.getThis().getField(cachedInstanceBinder.getCachedInstance((MethodHandle)instanceFactory));
        ifStatement.ifTrue((BytecodeNode)new ForLoop("nullable range based loop", new Object[0]).initialize((BytecodeNode)position.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)position.increment()).body((BytecodeNode)new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockPositionNotNull(this.callExpression.arguments(), functionNullability.getArgumentNullable(), scope, position)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)CallColumnarFilterGenerator.generateFullInvocation(this.functionManager, instance, callSiteBinder, this.callExpression, scope, (BytecodeExpression)position).putVariable(result)).append((BytecodeNode)ColumnarFilterCompiler.updateOutputPositions(result, position, outputPositions, outputPositionsCount)))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("nullable function range based loop", new Object[0]).initialize((BytecodeNode)position.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)position.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)CallColumnarFilterGenerator.generateFullInvocation(this.functionManager, instance, callSiteBinder, this.callExpression, scope, (BytecodeExpression)position).putVariable(result)).append((BytecodeNode)ColumnarFilterCompiler.updateOutputPositions(result, position, outputPositions, outputPositionsCount))));
        body.append((BytecodeNode)outputPositionsCount.ret());
    }

    private void generateFilterListMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter outputPositions = Parameter.arg((String)"outputPositions", int[].class);
        Parameter activePositions = Parameter.arg((String)"activePositions", int[].class);
        Parameter offset = Parameter.arg((String)"offset", Integer.TYPE);
        Parameter size = Parameter.arg((String)"size", Integer.TYPE);
        Parameter page = Parameter.arg((String)"page", SourcePage.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filterPositionsList", ParameterizedType.type(Integer.TYPE), (Iterable)ImmutableList.of((Object)session, (Object)outputPositions, (Object)activePositions, (Object)offset, (Object)size, (Object)page));
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        ColumnarFilterCompiler.declareBlockVariables(this.callExpression.arguments(), page, scope, body);
        Variable outputPositionsCount = scope.declareVariable("outputPositionsCount", body, BytecodeExpressions.constantInt((int)0));
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        FunctionNullability functionNullability = this.callExpression.resolvedFunction().functionNullability();
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockMayHaveNull(this.callExpression.arguments(), functionNullability.getArgumentNullable(), scope));
        body.append((BytecodeNode)ifStatement);
        Function<MethodHandle, BytecodeNode> instance = instanceFactory -> scope.getThis().getField(cachedInstanceBinder.getCachedInstance((MethodHandle)instanceFactory));
        ifStatement.ifTrue((BytecodeNode)new ForLoop("nullable positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)position.set(activePositions.getElement((BytecodeExpression)index))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)ColumnarFilterCompiler.generateBlockPositionNotNull(this.callExpression.arguments(), functionNullability.getArgumentNullable(), scope, position)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)CallColumnarFilterGenerator.generateFullInvocation(this.functionManager, instance, callSiteBinder, this.callExpression, scope, (BytecodeExpression)position).putVariable(result)).append((BytecodeNode)ColumnarFilterCompiler.updateOutputPositions(result, position, outputPositions, outputPositionsCount))))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("non-nullable positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)offset)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)BytecodeExpressions.add((BytecodeExpression)offset, (BytecodeExpression)size))).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)position.set(activePositions.getElement((BytecodeExpression)index))).append((BytecodeNode)CallColumnarFilterGenerator.generateFullInvocation(this.functionManager, instance, callSiteBinder, this.callExpression, scope, (BytecodeExpression)position).putVariable(result)).append((BytecodeNode)ColumnarFilterCompiler.updateOutputPositions(result, position, outputPositions, outputPositionsCount))));
        body.append((BytecodeNode)outputPositionsCount.ret());
    }

    static BytecodeBlock generateInvocation(FunctionManager functionManager, CallSiteBinder binder, CallExpression callExpression, Scope scope, BytecodeExpression position) {
        return CallColumnarFilterGenerator.generateFullInvocation(functionManager, methodHandle -> {
            throw new IllegalArgumentException("Simple method invocation can not be used with functions that require an instance factory");
        }, binder, callExpression, scope, position);
    }

    private static BytecodeBlock generateFullInvocation(FunctionManager functionManager, Function<MethodHandle, BytecodeNode> instanceFactory, CallSiteBinder binder, CallExpression callExpression, Scope scope, BytecodeExpression position) {
        ResolvedFunction resolvedFunction = callExpression.resolvedFunction();
        String functionName = resolvedFunction.signature().getName().getFunctionName();
        BytecodeBlock block = new BytecodeBlock().setDescription("invoke " + functionName);
        ScalarFunctionImplementation implementation = CallColumnarFilterGenerator.getScalarFunctionImplementation(functionManager, callExpression);
        Binding binding = binder.bind(implementation.getMethodHandle());
        Optional<BytecodeNode> instance = implementation.getInstanceFactory().map(instanceFactory);
        MethodType methodType = binding.getType();
        boolean instanceIsBound = false;
        for (int currentParameterIndex = 0; currentParameterIndex < methodType.parameterArray().length; ++currentParameterIndex) {
            Class<?> type = methodType.parameterArray()[currentParameterIndex];
            if (instance.isPresent() && !instanceIsBound) {
                Preconditions.checkState((boolean)type.equals(((MethodHandle)implementation.getInstanceFactory().get()).type().returnType()), (Object)"Mismatched type for instance parameter");
                block.append(instance.get());
                instanceIsBound = true;
                continue;
            }
            if (type != ConnectorSession.class) continue;
            block.append((BytecodeNode)scope.getVariable("session"));
        }
        for (RowExpression argumentExpression : callExpression.arguments()) {
            if (argumentExpression instanceof InputReferenceExpression) {
                InputReferenceExpression inputReference = (InputReferenceExpression)argumentExpression;
                block.append(CallColumnarFilterGenerator.generateInputReference((BytecodeExpression)scope.getVariable("block_" + inputReference.field()), position));
                continue;
            }
            if (argumentExpression instanceof ConstantExpression) {
                ConstantExpression constant = (ConstantExpression)argumentExpression;
                block.append(CallColumnarFilterGenerator.generateConstant(binder, constant));
                continue;
            }
            throw new UnsupportedOperationException(String.format("CallExpression %s is not supported", callExpression));
        }
        block.append((BytecodeNode)BytecodeUtils.invoke(binding, functionName, new BytecodeExpression[0]));
        return block;
    }

    private static ScalarFunctionImplementation getScalarFunctionImplementation(FunctionManager functionManager, CallExpression callExpression) {
        ResolvedFunction resolvedFunction = callExpression.resolvedFunction();
        List<RowExpression> argumentExpressions = callExpression.arguments();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)argumentExpressions.size());
        for (RowExpression argumentExpression : argumentExpressions) {
            if (argumentExpression instanceof InputReferenceExpression) {
                builder.add((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION);
                continue;
            }
            if (argumentExpression instanceof ConstantExpression) {
                builder.add((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
                continue;
            }
            throw new UnsupportedOperationException(String.format("CallExpression %s is not supported", callExpression));
        }
        InvocationConvention invocationConvention = new InvocationConvention((List)builder.build(), resolvedFunction.functionNullability().isReturnNullable() ? InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, true);
        return functionManager.getScalarFunctionImplementation(resolvedFunction, invocationConvention);
    }

    private static BytecodeNode generateInputReference(BytecodeExpression block, BytecodeExpression position) {
        BytecodeBlock blockAndPosition = new BytecodeBlock();
        blockAndPosition.append((BytecodeNode)block);
        blockAndPosition.append((BytecodeNode)position);
        return blockAndPosition;
    }

    private static BytecodeNode generateConstant(CallSiteBinder callSiteBinder, ConstantExpression constant) {
        Object value = constant.value();
        Class javaType = constant.type().getJavaType();
        BytecodeBlock block = new BytecodeBlock();
        block.comment("constant " + String.valueOf(constant.type().getTypeSignature()));
        if (javaType == Boolean.TYPE) {
            return block.append((BytecodeNode)Constant.loadBoolean((boolean)((Boolean)value)));
        }
        if (javaType == Long.TYPE) {
            return block.append((BytecodeNode)Constant.loadLong((long)((Long)value)));
        }
        if (javaType == Double.TYPE) {
            return block.append((BytecodeNode)Constant.loadDouble((double)((Double)value)));
        }
        if (javaType == String.class) {
            return block.append((BytecodeNode)Constant.loadString((String)((String)value)));
        }
        Binding binding = callSiteBinder.bind(value, constant.type().getJavaType());
        return new BytecodeBlock().setDescription("constant " + String.valueOf(constant.type())).comment(constant.toString()).append((BytecodeNode)BytecodeUtils.loadConstant(binding));
    }

    private static void generateConstructor(ClassDefinition classDefinition, CachedInstanceBinder cachedInstanceBinder) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }

    private static final class CachedInstanceBinder {
        private final ClassDefinition classDefinition;
        private final CallSiteBinder callSiteBinder;
        private Optional<FieldDefinition> field = Optional.empty();
        private Optional<MethodHandle> method = Optional.empty();

        public CachedInstanceBinder(ClassDefinition classDefinition, CallSiteBinder callSiteBinder) {
            this.classDefinition = Objects.requireNonNull(classDefinition, "classDefinition is null");
            this.callSiteBinder = Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        }

        public FieldDefinition getCachedInstance(MethodHandle methodHandle) {
            if (this.field.isEmpty()) {
                this.field = Optional.of(this.classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "__cachedInstance", (Class)methodHandle.type().returnType()));
                this.method = Optional.of(methodHandle);
            }
            return this.field.get();
        }

        public void generateInitializations(Variable thisVariable, BytecodeBlock block) {
            if (this.field.isPresent()) {
                Binding binding = this.callSiteBinder.bind(this.method.orElseThrow());
                block.append((BytecodeNode)thisVariable).append((BytecodeNode)BytecodeUtils.invoke(binding, "instanceFieldConstructor", new BytecodeExpression[0])).putField(this.field.get());
            }
        }
    }
}

