/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record Row(List<Expression> items, Type type) implements Expression
{
    public Row(List<Expression> items) {
        this(items, (Type)RowType.anonymous(items.stream().map(Expression::type).collect(Collectors.toList())));
    }

    public Row(List<Expression> items, Type type) {
        Objects.requireNonNull(items, "items is null");
        this.items = items = ImmutableList.copyOf(items);
        this.type = type;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return this.items;
    }

    @Override
    public String toString() {
        return "(" + this.items.stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", ")) + ")";
    }
}

