/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.Reference;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public final class CanonicalizeExpressionRewriter {
    private static final CatalogSchemaFunctionName MULTIPLY_BUILTIN_FUNCTION = GlobalFunctionCatalog.builtinFunctionName(OperatorType.MULTIPLY);
    private static final CatalogSchemaFunctionName ADD_BUILTIN_FUNCTION = GlobalFunctionCatalog.builtinFunctionName(OperatorType.ADD);

    public static Expression canonicalizeExpression(Expression expression, PlannerContext plannerContext) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(plannerContext), expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, PlannerContext plannerContext) {
        if (expression instanceof Reference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith(new Visitor(plannerContext), expression);
    }

    private static OperatorType getOperator(CatalogSchemaFunctionName function) {
        OperatorType operatorType;
        CatalogSchemaFunctionName catalogSchemaFunctionName = function;
        Objects.requireNonNull(catalogSchemaFunctionName);
        CatalogSchemaFunctionName catalogSchemaFunctionName2 = catalogSchemaFunctionName;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CatalogSchemaFunctionName.class, CatalogSchemaFunctionName.class}, (CatalogSchemaFunctionName)catalogSchemaFunctionName2, n)) {
                case 0: {
                    CatalogSchemaFunctionName name = catalogSchemaFunctionName2;
                    if (!name.equals((Object)ADD_BUILTIN_FUNCTION)) {
                        n = 1;
                        continue block4;
                    }
                    operatorType = OperatorType.ADD;
                    break block4;
                }
                case 1: {
                    CatalogSchemaFunctionName name = catalogSchemaFunctionName2;
                    if (!name.equals((Object)MULTIPLY_BUILTIN_FUNCTION)) {
                        n = 2;
                        continue block4;
                    }
                    operatorType = OperatorType.MULTIPLY;
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected operator: " + String.valueOf(function));
                }
            }
            break;
        }
        return operatorType;
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final PlannerContext plannerContext;

        public Visitor(PlannerContext plannerContext) {
            this.plannerContext = plannerContext;
        }

        @Override
        public Expression rewriteComparison(Comparison node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.isConstant(node.left()) && !this.isConstant(node.right())) {
                node = new Comparison(node.operator().flip(), node.right(), node.left());
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        @Override
        public Expression rewriteCall(Call node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression argument;
            Type argumentType;
            CatalogSchemaFunctionName functionName = node.function().name();
            if (functionName.equals((Object)MULTIPLY_BUILTIN_FUNCTION) || functionName.equals((Object)ADD_BUILTIN_FUNCTION)) {
                Expression left = treeRewriter.rewrite(node.arguments().get(0), context);
                Expression right = treeRewriter.rewrite(node.arguments().get(1), context);
                if (this.isConstant(left) && !this.isConstant(right)) {
                    return new Call(this.plannerContext.getMetadata().resolveOperator(CanonicalizeExpressionRewriter.getOperator(functionName), (List<? extends Type>)ImmutableList.of((Object)node.function().signature().getArgumentType(1), (Object)node.function().signature().getArgumentType(0))), (List<Expression>)ImmutableList.of((Object)right, (Object)left));
                }
                return new Call(node.function(), (List<Expression>)ImmutableList.of((Object)left, (Object)right));
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date")) && node.arguments().size() == 1 && ((argumentType = (argument = node.arguments().get(0)).type()) instanceof TimestampType || argumentType instanceof TimestampWithTimeZoneType || argumentType instanceof VarcharType)) {
                return new Cast(treeRewriter.rewrite(argument, context), (Type)DateType.DATE);
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        private boolean isConstant(Expression expression) {
            return expression instanceof Constant;
        }
    }
}

