/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Optional;

public class PushdownLimitIntoWindow
implements Rule<LimitNode> {
    private static final Capture<WindowNode> childCapture = Capture.newCapture();
    private final Pattern<LimitNode> pattern = Patterns.limit().matching(limit -> !limit.isWithTies() && limit.getCount() != 0L && limit.getCount() <= Integer.MAX_VALUE && !limit.requiresPreSortedInputs()).with(Patterns.source().matching(Patterns.window().matching(window -> window.getOrderingScheme().isPresent()).matching(window -> Util.toTopNRankingType(window).isPresent()).capturedAs(childCapture)));

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeTopNRanking(session);
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return this.pattern;
    }

    @Override
    public Rule.Result apply(LimitNode node, Captures captures, Rule.Context context) {
        WindowNode source = (WindowNode)captures.get(childCapture);
        Optional<TopNRankingNode.RankingType> rankingType = Util.toTopNRankingType(source);
        int limit = Math.toIntExact(node.getCount());
        TopNRankingNode topNRowNumberNode = new TopNRankingNode(source.getId(), source.getSource(), source.getSpecification(), rankingType.get(), (Symbol)Iterables.getOnlyElement(source.getWindowFunctions().keySet()), limit, false, Optional.empty());
        if (rankingType.get() == TopNRankingNode.RankingType.ROW_NUMBER && source.getPartitionBy().isEmpty()) {
            return Rule.Result.ofPlanNode(topNRowNumberNode);
        }
        return Rule.Result.ofPlanNode(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)topNRowNumberNode)));
    }
}

