/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.operator.table.ExcludeColumnsFunction;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import java.util.List;

public class RewriteExcludeColumnsFunctionToProjection
implements Rule<TableFunctionProcessorNode> {
    private static final Pattern<TableFunctionProcessorNode> PATTERN = Patterns.tableFunctionProcessor();

    @Override
    public Pattern<TableFunctionProcessorNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionProcessorNode node, Captures captures, Rule.Context context) {
        if (!(node.getHandle().functionHandle() instanceof ExcludeColumnsFunction.ExcludeColumnsFunctionHandle)) {
            return Rule.Result.empty();
        }
        List inputSymbols = (List)Iterables.getOnlyElement(node.getRequiredSymbols());
        List<Symbol> outputSymbols = node.getOutputSymbols();
        Preconditions.checkState((inputSymbols.size() == outputSymbols.size() ? 1 : 0) != 0, (Object)"inputSymbols size differs from outputSymbols size");
        Assignments.Builder assignments = Assignments.builder();
        for (int i = 0; i < outputSymbols.size(); ++i) {
            assignments.put(outputSymbols.get(i), ((Symbol)inputSymbols.get(i)).toSymbolReference());
        }
        return Rule.Result.ofPlanNode(new ProjectNode(node.getId(), node.getSource().orElseThrow(), assignments.build()));
    }
}

