/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableMap;
import io.trino.execution.TableInfo;
import io.trino.metadata.IndexHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionFormatter;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.planprinter.Anonymizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CounterBasedAnonymizer
implements Anonymizer {
    private final ExpressionFormatter.Formatter anonymizeExpressionFormatter = new ExpressionFormatter.Formatter(Optional.of(this::anonymizeLiteral), Optional.of(this::anonymizeSymbolReference));
    private final Map<String, String> anonymizedMap = new HashMap<String, String>();
    private final Map<ObjectType, Integer> counterMap = Arrays.stream(ObjectType.values()).collect(Collectors.toMap(objectType -> objectType, objectType -> 0));

    @Override
    public String anonymize(Type type, String value) {
        String formattedTypeName = type.getDisplayName().replaceAll("\\W", "_").replaceAll("__", "_");
        return formattedTypeName + "_" + this.anonymize(value, ObjectType.VALUE);
    }

    @Override
    public String anonymize(Symbol symbol) {
        return this.anonymize(symbol.name(), ObjectType.SYMBOL);
    }

    @Override
    public String anonymizeColumn(String symbol) {
        return this.anonymize(symbol, ObjectType.COLUMN);
    }

    @Override
    public String anonymize(Expression expression) {
        return (String)this.anonymizeExpressionFormatter.process(expression);
    }

    private String anonymizeSymbolReference(Reference node) {
        return "\"" + this.anonymize(Symbol.from(node)) + "\"";
    }

    private String anonymizeLiteral(Constant literal) {
        if (literal.value() == null) {
            return "null";
        }
        if (literal.type().equals((Object)BooleanType.BOOLEAN)) {
            return literal.value().toString();
        }
        return this.anonymizeLiteral(literal.type().getDisplayName(), literal.value());
    }

    private <T> String anonymizeLiteral(String type, T value) {
        return "'" + type + "_" + this.anonymize(value, ObjectType.LITERAL) + "'";
    }

    @Override
    public String anonymize(ColumnHandle columnHandle) {
        return this.anonymize(columnHandle, ObjectType.COLUMN);
    }

    @Override
    public String anonymize(QualifiedObjectName objectName) {
        return this.anonymize(objectName.catalogName(), objectName.schemaName(), objectName.objectName());
    }

    @Override
    public String anonymize(Partitioning.ArgumentBinding argument) {
        if (argument.getConstant() != null) {
            return argument.getConstant().toString();
        }
        return this.anonymize(argument.getExpression());
    }

    @Override
    public String anonymize(IndexHandle indexHandle) {
        return CounterBasedAnonymizer.formatMap((Map<String, String>)ImmutableMap.of((Object)"catalog", (Object)this.anonymize(indexHandle.catalogHandle().getCatalogName().toString(), ObjectType.CATALOG), (Object)"connectorHandleType", (Object)indexHandle.connectorHandle().getClass().getSimpleName()));
    }

    @Override
    public String anonymize(TableHandle tableHandle, TableInfo tableInfo) {
        ImmutableMap.Builder result = ImmutableMap.builder().put((Object)"table", (Object)this.anonymize(tableInfo.getTableName()));
        tableInfo.getConnectorName().ifPresent(connector -> result.put((Object)"connector", connector));
        return CounterBasedAnonymizer.formatMap((Map<String, String>)result.buildOrThrow());
    }

    @Override
    public String anonymize(PartitioningHandle partitioningHandle) {
        ConnectorPartitioningHandle connectorHandle = partitioningHandle.getConnectorHandle();
        ImmutableMap.Builder result = ImmutableMap.builder().put((Object)"connectorHandleType", (Object)connectorHandle.getClass().getSimpleName());
        partitioningHandle.getCatalogHandle().ifPresent(catalog -> result.put((Object)"catalog", (Object)this.anonymize(catalog.getCatalogName().toString(), ObjectType.CATALOG)));
        if (connectorHandle instanceof SystemPartitioningHandle) {
            SystemPartitioningHandle systemPartitioningHandle = (SystemPartitioningHandle)connectorHandle;
            result.put((Object)"partitioning", (Object)systemPartitioningHandle.getPartitioningName()).put((Object)"function", (Object)systemPartitioningHandle.getFunction().name());
        }
        return CounterBasedAnonymizer.formatMap((Map<String, String>)result.buildOrThrow());
    }

    @Override
    public String anonymize(TableWriterNode.WriterTarget target) {
        if (target instanceof TableWriterNode.CreateTarget) {
            TableWriterNode.CreateTarget createTarget = (TableWriterNode.CreateTarget)target;
            return this.anonymize(createTarget);
        }
        if (target instanceof TableWriterNode.InsertTarget) {
            TableWriterNode.InsertTarget insertTarget = (TableWriterNode.InsertTarget)target;
            return this.anonymize(insertTarget);
        }
        if (target instanceof TableWriterNode.MergeTarget) {
            TableWriterNode.MergeTarget mergeTarget = (TableWriterNode.MergeTarget)target;
            return this.anonymize(mergeTarget);
        }
        if (target instanceof TableWriterNode.RefreshMaterializedViewTarget) {
            TableWriterNode.RefreshMaterializedViewTarget refreshMaterializedViewTarget = (TableWriterNode.RefreshMaterializedViewTarget)target;
            return this.anonymize(refreshMaterializedViewTarget);
        }
        if (target instanceof TableWriterNode.TableExecuteTarget) {
            TableWriterNode.TableExecuteTarget tableExecuteTarget = (TableWriterNode.TableExecuteTarget)target;
            return this.anonymize(tableExecuteTarget);
        }
        throw new UnsupportedOperationException("Anonymization is not supported for WriterTarget type: " + target.getClass().getSimpleName());
    }

    @Override
    public String anonymize(StatisticsWriterNode.WriteStatisticsTarget target) {
        if (target instanceof StatisticsWriterNode.WriteStatisticsHandle) {
            StatisticsWriterNode.WriteStatisticsHandle writeStatisticsHandle = (StatisticsWriterNode.WriteStatisticsHandle)target;
            return this.anonymize(writeStatisticsHandle.getHandle().catalogHandle().getCatalogName().toString(), ObjectType.CATALOG);
        }
        throw new UnsupportedOperationException("Anonymization is not supported for WriterTarget type: " + target.getClass().getSimpleName());
    }

    @Override
    public String anonymize(TableHandle tableHandle) {
        return this.anonymize(tableHandle.catalogHandle().getCatalogName().toString(), ObjectType.CATALOG);
    }

    @Override
    public String anonymize(TableExecuteHandle tableHandle) {
        return this.anonymize(tableHandle.catalogHandle().getCatalogName().toString(), ObjectType.CATALOG);
    }

    private String anonymize(TableWriterNode.CreateTarget target) {
        return this.anonymize(target.getHandle().catalogHandle().getCatalogName().toString(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.InsertTarget target) {
        return this.anonymize(target.getHandle().catalogHandle().getCatalogName().toString(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.MergeTarget target) {
        return this.anonymize(target.getHandle().catalogHandle().getCatalogName().toString(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.RefreshMaterializedViewTarget target) {
        return this.anonymize(target.getInsertHandle().catalogHandle().getCatalogName().toString(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.TableExecuteTarget target) {
        return this.anonymize(target.getExecuteHandle().catalogHandle().getCatalogName().toString(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(String catalogName, String schemaName, String objectName) {
        return new QualifiedObjectName(this.anonymize(catalogName, ObjectType.CATALOG), this.anonymize(schemaName, ObjectType.SCHEMA), this.anonymize(objectName, ObjectType.TABLE)).toString();
    }

    private <T> String anonymize(T object, ObjectType objectType) {
        return this.anonymizedMap.computeIfAbsent(objectType.name() + String.valueOf(object), string -> {
            Integer counter = this.counterMap.computeIfPresent(objectType, (k, v) -> v + 1);
            return objectType.name().toLowerCase(Locale.ENGLISH) + "_" + counter;
        });
    }

    private static String formatMap(Map<String, String> map) {
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(Collectors.joining(", ", "[", "]"));
    }

    private static enum ObjectType {
        CATALOG,
        SCHEMA,
        TABLE,
        COLUMN,
        SYMBOL,
        LITERAL,
        VALUE;

    }
}

