/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Provider;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.node.NodeInfo;
import io.airlift.tracing.Tracing;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogServiceProviderModule;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.CoordinatorDynamicCatalogManager;
import io.trino.connector.DefaultCatalogFactory;
import io.trino.connector.InMemoryCatalogStore;
import io.trino.connector.LazyCatalogFactory;
import io.trino.connector.system.AnalyzePropertiesSystemTable;
import io.trino.connector.system.CatalogSystemTable;
import io.trino.connector.system.ColumnPropertiesSystemTable;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.connector.system.MaterializedViewPropertiesSystemTable;
import io.trino.connector.system.MaterializedViewSystemTable;
import io.trino.connector.system.NodeSystemTable;
import io.trino.connector.system.SchemaPropertiesSystemTable;
import io.trino.connector.system.TableCommentSystemTable;
import io.trino.connector.system.TablePropertiesSystemTable;
import io.trino.connector.system.TransactionsSystemTable;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostCalculatorUsingExchanges;
import io.trino.cost.CostCalculatorWithEstimatedExchanges;
import io.trino.cost.CostComparator;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsCalculatorModule;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.TaskCountEstimator;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPreparer;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SessionPropertyEvaluator;
import io.trino.execution.SplitAssignment;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.resourcegroups.NoOpResourceGroupManager;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.execution.warnings.WarningCollector;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.HandleResolver;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.LanguageFunctionEngineManager;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.Split;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TypeRegistry;
import io.trino.metadata.ViewPropertyManager;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverFactory;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.operator.TaskContext;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.operator.index.IndexManager;
import io.trino.operator.scalar.json.JsonExistsFunction;
import io.trino.operator.scalar.json.JsonQueryFunction;
import io.trino.operator.scalar.json.JsonValueFunction;
import io.trino.operator.table.ExcludeColumnsFunction;
import io.trino.security.AllowAllAccessControl;
import io.trino.security.GroupProviderManager;
import io.trino.server.PluginManager;
import io.trino.server.ServerConfig;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.protocol.spooling.QueryDataEncoders;
import io.trino.server.protocol.spooling.SpoolingEnabledConfig;
import io.trino.server.protocol.spooling.SpoolingManagerRegistry;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.HeaderAuthenticatorConfig;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.spi.Plugin;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorName;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.split.SplitSource;
import io.trino.sql.PlannerContext;
import io.trino.sql.SessionPropertyResolver;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.analyzer.SessionTimeProvider;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.gen.CursorProcessorCompiler;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.AdaptivePlanner;
import io.trino.sql.planner.CompilerConfig;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.optimizations.AdaptivePlanOptimizer;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.rewrite.DescribeInputRewrite;
import io.trino.sql.rewrite.DescribeOutputRewrite;
import io.trino.sql.rewrite.ExplainRewrite;
import io.trino.sql.rewrite.ShowQueriesRewrite;
import io.trino.sql.rewrite.ShowStatsRewrite;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.testing.TreeAssertions;
import io.trino.sql.tree.Node;
import io.trino.testing.NotImplementedQueryManager;
import io.trino.testing.NullOutputOperator;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProviderManager;
import io.trino.testing.TestingTaskContext;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonPath2016Type;
import io.trino.type.TypeDeserializer;
import io.trino.util.EmbedVersion;
import io.trino.util.FinalizerService;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public class PlanTester
implements Closeable {
    private final Session defaultSession;
    private final ExecutorService notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final FinalizerService finalizerService;
    private final SqlParser sqlParser;
    private final PlanFragmenter planFragmenter;
    private final InternalNodeManager nodeManager;
    private final TypeOperators typeOperators;
    private final BlockTypeOperators blockTypeOperators;
    private final PlannerContext plannerContext;
    private final GlobalFunctionCatalog globalFunctionCatalog;
    private final StatsCalculator statsCalculator;
    private final ScalarStatsCalculator scalarStatsCalculator;
    private final CostCalculator costCalculator;
    private final CostCalculator estimatedExchangesCostCalculator;
    private final TaskCountEstimator taskCountEstimator;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final TransactionManager transactionManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final ViewPropertyManager viewPropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ColumnarFilterCompiler filterCompiler;
    private final ExpressionCompiler expressionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final JoinCompiler joinCompiler;
    private final FlatHashStrategyCompiler hashStrategyCompiler;
    private final CatalogFactory catalogFactory;
    private final CoordinatorDynamicCatalogManager catalogManager;
    private final PluginManager pluginManager;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final SpoolingManagerRegistry spoolingManagerRegistry;
    private final TaskManagerConfig taskManagerConfig;
    private final OptimizerConfig optimizerConfig;
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private boolean printPlan;

    public static PlanTester create(Session defaultSession) {
        return new PlanTester(defaultSession, 1);
    }

    public static PlanTester create(Session defaultSession, int nodeCountForStats) {
        return new PlanTester(defaultSession, nodeCountForStats);
    }

    private PlanTester(Session defaultSession, int nodeCountForStats) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Tracer tracer = Tracing.noopTracer();
        this.taskManagerConfig = new TaskManagerConfig().setTaskConcurrency(4);
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.typeOperators = new TypeOperators();
        this.blockTypeOperators = new BlockTypeOperators(this.typeOperators);
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager(new InternalNode[0]);
        PagesIndexPageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(true);
        this.optimizerConfig = new OptimizerConfig();
        LazyCatalogFactory catalogFactory = new LazyCatalogFactory();
        this.catalogFactory = catalogFactory;
        this.catalogManager = new CoordinatorDynamicCatalogManager(new InMemoryCatalogStore(), catalogFactory, MoreExecutors.directExecutor());
        this.transactionManager = InMemoryTransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.yieldExecutor, this.catalogManager, this.notificationExecutor);
        BlockEncodingManager blockEncodingManager = new BlockEncodingManager();
        TypeRegistry typeRegistry = new TypeRegistry(this.typeOperators, new FeaturesConfig());
        InternalTypeManager typeManager = new InternalTypeManager(typeRegistry);
        InternalBlockEncodingSerde blockEncodingSerde = new InternalBlockEncodingSerde(blockEncodingManager, typeManager);
        SecretsResolver secretsResolver = new SecretsResolver((Map)ImmutableMap.of());
        this.globalFunctionCatalog = new GlobalFunctionCatalog((Provider<Metadata>)((Provider)() -> this.getPlannerContext().getMetadata()), (Provider<TypeManager>)((Provider)() -> this.getPlannerContext().getTypeManager()), (Provider<FunctionManager>)((Provider)() -> this.getPlannerContext().getFunctionManager()));
        this.globalFunctionCatalog.addFunctions(SystemFunctionBundle.create(new FeaturesConfig(), this.typeOperators, this.blockTypeOperators, this.nodeManager.getCurrentNode().getNodeVersion()));
        TestingGroupProviderManager groupProvider = new TestingGroupProviderManager();
        LanguageFunctionManager languageFunctionManager = new LanguageFunctionManager(this.sqlParser, typeManager, groupProvider, blockEncodingSerde, new LanguageFunctionEngineManager());
        TableFunctionRegistry tableFunctionRegistry = new TableFunctionRegistry(CatalogServiceProviderModule.createTableFunctionProvider(this.catalogManager));
        MetadataManager metadata = new MetadataManager(new AllowAllAccessControl(), new DisabledSystemSecurityMetadata(), this.transactionManager, this.globalFunctionCatalog, languageFunctionManager, tableFunctionRegistry, typeManager, new NotImplementedQueryManager());
        typeRegistry.addType((Type)new JsonPath2016Type(new TypeDeserializer(typeManager), blockEncodingSerde));
        this.joinCompiler = new JoinCompiler(this.typeOperators);
        this.hashStrategyCompiler = new FlatHashStrategyCompiler(this.typeOperators);
        GroupByHashPageIndexerFactory pageIndexerFactory = new GroupByHashPageIndexerFactory(this.hashStrategyCompiler);
        EventListenerManager eventListenerManager = new EventListenerManager(new EventListenerConfig(), secretsResolver, OpenTelemetry.noop(), tracer, this.nodeManager.getCurrentNode().getNodeVersion());
        this.accessControl = new TestingAccessControlManager(this.transactionManager, eventListenerManager, secretsResolver);
        this.accessControl.loadSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
        NodeInfo nodeInfo = new NodeInfo("test");
        catalogFactory.setCatalogFactory(new DefaultCatalogFactory(metadata, this.accessControl, this.nodeManager, pageSorter, pageIndexerFactory, nodeInfo, EmbedVersion.testingVersionEmbedder(), OpenTelemetry.noop(), this.transactionManager, typeManager, nodeSchedulerConfig, this.optimizerConfig, secretsResolver));
        this.splitManager = new SplitManager(CatalogServiceProviderModule.createSplitManagerProvider(this.catalogManager), tracer, new QueryManagerConfig());
        this.pageSourceManager = new PageSourceManager(CatalogServiceProviderModule.createPageSourceProviderFactory(this.catalogManager));
        this.pageSinkManager = new PageSinkManager(CatalogServiceProviderModule.createPageSinkProvider(this.catalogManager));
        this.indexManager = new IndexManager(CatalogServiceProviderModule.createIndexProvider(this.catalogManager));
        NodeScheduler nodeScheduler = new NodeScheduler(new UniformNodeSelectorFactory(this.nodeManager, nodeSchedulerConfig, new NodeTaskMap(this.finalizerService)));
        this.sessionPropertyManager = PlanTester.createSessionPropertyManager(this.catalogManager, this.taskManagerConfig, this.optimizerConfig);
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler, this.typeOperators, CatalogServiceProviderModule.createNodePartitioningProvider(this.catalogManager));
        TableProceduresRegistry tableProceduresRegistry = new TableProceduresRegistry(CatalogServiceProviderModule.createTableProceduresProvider(this.catalogManager));
        FunctionManager functionManager = new FunctionManager(CatalogServiceProviderModule.createFunctionProvider(this.catalogManager), this.globalFunctionCatalog, languageFunctionManager);
        this.schemaPropertyManager = CatalogServiceProviderModule.createSchemaPropertyManager(this.catalogManager);
        this.columnPropertyManager = CatalogServiceProviderModule.createColumnPropertyManager(this.catalogManager);
        this.tablePropertyManager = CatalogServiceProviderModule.createTablePropertyManager(this.catalogManager);
        this.viewPropertyManager = CatalogServiceProviderModule.createViewPropertyManager(this.catalogManager);
        this.materializedViewPropertyManager = CatalogServiceProviderModule.createMaterializedViewPropertyManager(this.catalogManager);
        this.analyzePropertyManager = CatalogServiceProviderModule.createAnalyzePropertyManager(this.catalogManager);
        TableProceduresPropertyManager tableProceduresPropertyManager = CatalogServiceProviderModule.createTableProceduresPropertyManager(this.catalogManager);
        this.accessControl.setConnectorAccessControlProvider(CatalogServiceProviderModule.createAccessControlProvider(this.catalogManager));
        this.globalFunctionCatalog.addFunctions(new InternalFunctionBundle(new JsonExistsFunction(functionManager, metadata, typeManager), new JsonValueFunction(functionManager, metadata, typeManager), new JsonQueryFunction(functionManager, metadata, typeManager)));
        this.plannerContext = new PlannerContext(metadata, this.typeOperators, blockEncodingSerde, typeManager, functionManager, languageFunctionManager, tracer);
        this.pageFunctionCompiler = new PageFunctionCompiler(functionManager, 0);
        this.filterCompiler = new ColumnarFilterCompiler(functionManager, 0);
        this.expressionCompiler = new ExpressionCompiler(new CursorProcessorCompiler(functionManager), this.pageFunctionCompiler, this.filterCompiler);
        this.joinFilterFunctionCompiler = new JoinFilterFunctionCompiler(functionManager);
        this.statementAnalyzerFactory = new StatementAnalyzerFactory(this.plannerContext, this.sqlParser, SessionTimeProvider.DEFAULT, this.accessControl, this.transactionManager, groupProvider, tableProceduresRegistry, tableFunctionRegistry, this.tablePropertyManager, this.analyzePropertyManager, tableProceduresPropertyManager);
        this.statsCalculator = PlanTester.createNewStatsCalculator(this.plannerContext);
        this.scalarStatsCalculator = new ScalarStatsCalculator(this.plannerContext);
        this.taskCountEstimator = new TaskCountEstimator(() -> nodeCountForStats);
        this.costCalculator = new CostCalculatorUsingExchanges(this.taskCountEstimator);
        this.estimatedExchangesCostCalculator = new CostCalculatorWithEstimatedExchanges(this.costCalculator, this.taskCountEstimator);
        this.planFragmenter = new PlanFragmenter(metadata, functionManager, this.transactionManager, this.catalogManager, languageFunctionManager, new QueryManagerConfig());
        GlobalSystemConnector globalSystemConnector = new GlobalSystemConnector((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(metadata, this.accessControl), (Object)new TableCommentSystemTable(metadata, this.accessControl), (Object)new MaterializedViewSystemTable(metadata, this.accessControl), (Object)new SchemaPropertiesSystemTable(metadata, this.accessControl, this.schemaPropertyManager), (Object)new TablePropertiesSystemTable(metadata, this.accessControl, this.tablePropertyManager), (Object[])new SystemTable[]{new MaterializedViewPropertiesSystemTable(metadata, this.accessControl, this.materializedViewPropertyManager), new ColumnPropertiesSystemTable(metadata, this.accessControl, this.columnPropertyManager), new AnalyzePropertiesSystemTable(metadata, this.accessControl, this.analyzePropertyManager), new TransactionsSystemTable(typeManager, this.transactionManager)}), (Set<Procedure>)ImmutableSet.of(), (Set<ConnectorTableFunction>)ImmutableSet.of((Object)((Object)new ExcludeColumnsFunction())));
        this.exchangeManagerRegistry = new ExchangeManagerRegistry(OpenTelemetry.noop(), Tracing.noopTracer(), secretsResolver);
        this.spoolingManagerRegistry = new SpoolingManagerRegistry(new ServerConfig(), new SpoolingEnabledConfig(), OpenTelemetry.noop(), Tracing.noopTracer());
        this.pluginManager = new PluginManager((loader, createClassLoader) -> {}, Optional.empty(), catalogFactory, this.globalFunctionCatalog, new LanguageFunctionEngineManager(), new NoOpResourceGroupManager(), this.accessControl, Optional.of(new PasswordAuthenticatorManager(new PasswordAuthenticatorConfig(), secretsResolver)), new CertificateAuthenticatorManager(secretsResolver), Optional.of(new HeaderAuthenticatorManager(new HeaderAuthenticatorConfig(), secretsResolver)), eventListenerManager, new GroupProviderManager(secretsResolver), new SessionPropertyDefaults(nodeInfo, this.accessControl, secretsResolver), typeRegistry, blockEncodingManager, new HandleResolver(), this.exchangeManagerRegistry, this.spoolingManagerRegistry);
        this.catalogManager.registerGlobalSystemConnector(globalSystemConnector);
        languageFunctionManager.setPlannerContext(this.plannerContext);
        this.defaultSession = new Session(defaultSession.getQueryId(), Span.getInvalid(), defaultSession.getTransactionId(), defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getOriginalIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getPath(), defaultSession.getTraceToken(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getClientInfo(), defaultSession.getClientTags(), defaultSession.getClientCapabilities(), defaultSession.getResourceEstimates(), defaultSession.getStart(), defaultSession.getSystemProperties(), defaultSession.getCatalogProperties(), this.sessionPropertyManager, defaultSession.getPreparedStatements(), defaultSession.getProtocolHeaders(), defaultSession.getExchangeEncryptionKey(), defaultSession.getQueryDataEncoding());
    }

    private static SessionPropertyManager createSessionPropertyManager(ConnectorServicesProvider connectorServicesProvider, TaskManagerConfig taskManagerConfig, OptimizerConfig optimizerConfig) {
        SystemSessionProperties sessionProperties = new SystemSessionProperties(new QueryManagerConfig(), taskManagerConfig, new MemoryManagerConfig(), new FeaturesConfig(), optimizerConfig, new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig());
        return CatalogServiceProviderModule.createSessionPropertyManager((Set<SystemSessionPropertiesProvider>)ImmutableSet.of((Object)sessionProperties), connectorServicesProvider);
    }

    private static StatsCalculator createNewStatsCalculator(PlannerContext plannerContext) {
        StatsNormalizer normalizer = new StatsNormalizer();
        ScalarStatsCalculator scalarStatsCalculator = new ScalarStatsCalculator(plannerContext);
        FilterStatsCalculator filterStatsCalculator = new FilterStatsCalculator(plannerContext, scalarStatsCalculator, normalizer);
        return new ComposableStatsCalculator((List<ComposableStatsCalculator.Rule<?>>)new StatsCalculatorModule.StatsRulesProvider(scalarStatsCalculator, filterStatsCalculator, normalizer).get());
    }

    @Override
    public void close() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.catalogManager.stop();
        this.finalizerService.destroy();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    public AnalyzePropertyManager getAnalyzePropertyManager() {
        return this.analyzePropertyManager;
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    public CostCalculator getCostCalculator() {
        return this.costCalculator;
    }

    public CostCalculator getEstimatedExchangesCostCalculator() {
        return this.estimatedExchangesCostCalculator;
    }

    public TaskCountEstimator getTaskCountEstimator() {
        return this.taskCountEstimator;
    }

    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.catalogFactory.addConnectorFactory(connectorFactory);
        this.catalogManager.createCatalog(new CatalogName(catalogName), new ConnectorName(connectorFactory.getName()), properties, false);
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    public void addFunctions(FunctionBundle functionBundle) {
        this.globalFunctionCatalog.addFunctions(functionBundle);
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.catalogManager.createCatalog(new CatalogName(catalogName), new ConnectorName(connectorName), properties, false);
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public Connector getConnector(String catalogName) {
        return this.catalogManager.getConnectorServices(this.getCatalogHandle(catalogName)).getConnector();
    }

    public PlanTester printPlan() {
        this.printPlan = true;
        return this;
    }

    public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.getDefaultSession(), transactionSessionConsumer);
    }

    public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.getTransactionManager(), this.getPlannerContext().getMetadata(), this.getAccessControl()).singleStatement().execute(session, transactionSessionConsumer);
    }

    public CatalogHandle getCatalogHandle(String catalogName) {
        return (CatalogHandle)this.inTransaction(transactionSession -> this.getPlannerContext().getMetadata().getCatalogHandle((Session)transactionSession, catalogName)).orElseThrow();
    }

    public TableHandle getTableHandle(String catalogName, String schemaName, String tableName) {
        return this.inTransaction(transactionSession -> this.getPlannerContext().getMetadata().getTableHandle((Session)transactionSession, new QualifiedObjectName(catalogName, schemaName, tableName)).orElseThrow());
    }

    public void executeStatement(@Language(value="SQL") String sql) {
        this.accessControl.checkCanExecuteQuery(this.defaultSession.getIdentity(), this.defaultSession.getQueryId());
        this.inTransaction(this.defaultSession, transactionSession -> {
            Object var6_10;
            block10: {
                Closer closer = Closer.create();
                try {
                    List<Driver> drivers = this.createDrivers((Session)transactionSession, sql);
                    drivers.forEach(arg_0 -> ((Closer)closer).register(arg_0));
                    boolean done = false;
                    while (!done) {
                        boolean processed = false;
                        for (Driver driver : drivers) {
                            if (driver.isFinished()) continue;
                            driver.processForNumberOfIterations(1);
                            processed = true;
                        }
                        done = !processed;
                    }
                    var6_10 = null;
                    if (closer == null) break block10;
                }
                catch (Throwable t$) {
                    try {
                        if (closer != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                closer.close();
            }
            return var6_10;
        });
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode) {
        this.plannerContext.getLanguageFunctionManager().tryRegisterQuery(session);
        return this.planFragmenter.createSubPlans(session, plan, forceSingleNode, WarningCollector.NOOP);
    }

    private List<Driver> createDrivers(Session session, @Language(value="SQL") String sql) {
        SubPlan subplan;
        Plan plan = this.createPlan(session, sql);
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), plan.getStatsAndCosts(), session, 0, false));
        }
        if (!(subplan = this.createSubPlans(session, plan, true)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected sub-plan to have no children");
        }
        TaskContext taskContext = TestingTaskContext.createTaskContext(this.notificationExecutor, this.yieldExecutor, session);
        TableExecuteContextManager tableExecuteContextManager = new TableExecuteContextManager();
        tableExecuteContextManager.registerTableExecuteContextForQuery(taskContext.getQueryContext().getQueryId());
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.plannerContext, Optional.empty(), this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, (queryId, exchangeId, span, localMemoryContext, taskFailureListener, retryPolicy) -> {
            throw new UnsupportedOperationException();
        }, this.expressionCompiler, this.pageFunctionCompiler, this.joinFilterFunctionCompiler, new IndexJoinLookupStats(), this.taskManagerConfig, new GenericSpillerFactory(SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory()), new QueryDataEncoders(new SpoolingEnabledConfig(), Set.of()), Optional.empty(), SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), new PagesIndex.TestingFactory(false), this.joinCompiler, this.hashStrategyCompiler, new OrderingCompiler(this.plannerContext.getTypeOperators()), new DynamicFilterConfig(), this.blockTypeOperators, this.typeOperators, tableExecuteContextManager, this.exchangeManagerRegistry, this.nodeManager.getCurrentNode().getNodeVersion(), new CompilerConfig());
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(taskContext, subplan.getFragment().getRoot(), subplan.getFragment().getOutputPartitioningScheme().getOutputLayout(), subplan.getFragment().getPartitionedSources(), new NullOutputOperator.NullOutputFactory());
        ArrayList<SplitAssignment> splitAssignments = new ArrayList<SplitAssignment>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : PlanTester.findTableScanNodes(subplan.getFragment().getRoot())) {
            TableHandle table = tableScan.getTable();
            SplitSource splitSource = this.splitManager.getSplits(session, Span.getInvalid(), table, DynamicFilter.EMPTY, Constraint.alwaysTrue());
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : PlanTester.getNextBatch(splitSource)) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            splitAssignments.add(new SplitAssignment(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, DriverFactory> driverFactoriesBySource = new HashMap<PlanNodeId, DriverFactory>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        ImmutableSet partitionedSources = ImmutableSet.copyOf(subplan.getFragment().getPartitionedSources());
        for (SplitAssignment splitAssignment : splitAssignments) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(splitAssignment.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            boolean partitioned = partitionedSources.contains(driverFactory.getSourceId().orElseThrow());
            for (ScheduledSplit split : splitAssignment.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSplitAssignment(new SplitAssignment(split.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)split), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.noMoreDrivers();
        }
        return ImmutableList.copyOf(drivers);
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql) {
        return this.createPlan(session, sql, this.getPlanOptimizers(true), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
    }

    public List<PlanOptimizer> getPlanOptimizers(boolean forceSingleNode) {
        return this.getPlanOptimizersFactory(forceSingleNode).getPlanOptimizers();
    }

    public List<AdaptivePlanOptimizer> getAdaptivePlanOptimizers() {
        return this.getPlanOptimizersFactory(false).getAdaptivePlanOptimizers();
    }

    public PlanOptimizersFactory getPlanOptimizersFactory(boolean forceSingleNode) {
        return new PlanOptimizers(this.plannerContext, this.taskManagerConfig, forceSingleNode, this.splitManager, this.pageSourceManager, this.statsCalculator, this.scalarStatsCalculator, this.costCalculator, this.estimatedExchangesCostCalculator, new CostComparator(this.optimizerConfig), this.taskCountEstimator, this.nodePartitioningManager, new RuleStatsRecorder());
    }

    public Plan createPlan(Session session, @Language(value="SQL") String sql, List<PlanOptimizer> optimizers, LogicalPlanner.Stage stage, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        this.transactionManager.getTransactionInfo(session.getRequiredTransactionId());
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer(this.sqlParser).prepareQuery(session, sql);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (Node)preparedQuery.getStatement());
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        AnalyzerFactory analyzerFactory = this.createAnalyzerFactory(this.createQueryExplainerFactory(optimizers));
        Analyzer analyzer = analyzerFactory.createAnalyzer(session, preparedQuery.getParameters(), ParameterExtractor.bindParameters(preparedQuery.getStatement(), preparedQuery.getParameters()), warningCollector, planOptimizersStatsCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, optimizers, new PlanSanityChecker(true), idAllocator, this.getPlannerContext(), this.statsCalculator, this.costCalculator, warningCollector, planOptimizersStatsCollector, new CachingTableStatsProvider(this.getPlannerContext().getMetadata(), session));
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        return logicalPlanner.plan(analysis, stage);
    }

    public SubPlan createAdaptivePlan(Session session, SubPlan subPlan, List<AdaptivePlanOptimizer> optimizers, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector, RuntimeInfoProvider runtimeInfoProvider) {
        AdaptivePlanner adaptivePlanner = new AdaptivePlanner(session, this.getPlannerContext(), optimizers, this.planFragmenter, new PlanSanityChecker(false), warningCollector, planOptimizersStatsCollector, new CachingTableStatsProvider(this.getPlannerContext().getMetadata(), session));
        return adaptivePlanner.optimize(subPlan, runtimeInfoProvider);
    }

    private QueryExplainerFactory createQueryExplainerFactory(List<PlanOptimizer> optimizers) {
        return new QueryExplainerFactory(this.createPlanOptimizersFactory(optimizers), this.planFragmenter, this.plannerContext, this.statsCalculator, this.costCalculator, new NodeVersion("test"));
    }

    private PlanOptimizersFactory createPlanOptimizersFactory(final List<PlanOptimizer> optimizers) {
        return new PlanOptimizersFactory(){

            @Override
            public List<PlanOptimizer> getPlanOptimizers() {
                return optimizers;
            }

            @Override
            public List<AdaptivePlanOptimizer> getAdaptivePlanOptimizers() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private AnalyzerFactory createAnalyzerFactory(QueryExplainerFactory queryExplainerFactory) {
        SessionPropertyResolver sessionPropertyResolver = new SessionPropertyResolver(new SessionPropertyEvaluator(this.plannerContext, this.accessControl, this.sessionPropertyManager, new SqlEnvironmentConfig()), this.accessControl);
        return new AnalyzerFactory(this.statementAnalyzerFactory, new StatementRewrite((Set<StatementRewrite.Rewrite>)ImmutableSet.of((Object)new DescribeInputRewrite(this.sqlParser), (Object)new DescribeOutputRewrite(this.sqlParser), (Object)new ShowQueriesRewrite(new SqlEnvironmentConfig(), this.plannerContext.getMetadata(), this.sqlParser, this.accessControl, this.sessionPropertyManager, this.schemaPropertyManager, this.columnPropertyManager, this.tablePropertyManager, this.viewPropertyManager, this.materializedViewPropertyManager), (Object)new ShowStatsRewrite(this.plannerContext.getMetadata(), queryExplainerFactory, this.statsCalculator), (Object)new ExplainRewrite(queryExplainerFactory, sessionPropertyResolver, new QueryPreparer(this.sqlParser)))), this.plannerContext.getTracer());
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(1000))).getSplits();
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        return (List)PlanNodeSearcher.searchFrom(node).where(TableScanNode.class::isInstance).findAll().stream().map(TableScanNode.class::cast).collect(ImmutableList.toImmutableList());
    }
}

