/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.stream.Collectors;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static String getDisplayLabel(Type type, boolean legacy) {
        if (legacy) {
            return TypeUtils.getDisplayLabelForLegacyClients(type);
        }
        return type.getDisplayName();
    }

    private static String getDisplayLabelForLegacyClients(Type type) {
        TimeWithTimeZoneType timeWithTimeZoneType;
        TimeType timeType;
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        TimestampType timestampType;
        if (type instanceof TimestampType && (timestampType = (TimestampType)type).getPrecision() == 3) {
            return "timestamp";
        }
        if (type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).getPrecision() == 3) {
            return "timestamp with time zone";
        }
        if (type instanceof TimeType && (timeType = (TimeType)type).getPrecision() == 3) {
            return "time";
        }
        if (type instanceof TimeWithTimeZoneType && (timeWithTimeZoneType = (TimeWithTimeZoneType)type).getPrecision() == 3) {
            return "time with time zone";
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return "array(" + TypeUtils.getDisplayLabelForLegacyClients(arrayType.getElementType()) + ")";
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return "map(" + TypeUtils.getDisplayLabelForLegacyClients(mapType.getKeyType()) + ", " + TypeUtils.getDisplayLabelForLegacyClients(mapType.getValueType()) + ")";
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return TypeUtils.getRowDisplayLabelForLegacyClients(rowType);
        }
        return type.getDisplayName();
    }

    private static String getRowDisplayLabelForLegacyClients(RowType type) {
        return type.getFields().stream().map(field -> {
            String typeDisplayName = TypeUtils.getDisplayLabelForLegacyClients(field.getType());
            if (field.getName().isPresent()) {
                return (String)field.getName().get() + " " + typeDisplayName;
            }
            return typeDisplayName;
        }).collect(Collectors.joining(", ", "row(", ")"));
    }
}

