/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.airlift.bytecode.BytecodeUtils;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassGenerator;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.log.Logger;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.MethodTooLargeException;

public final class CompilerUtils {
    private static final Logger log = Logger.get(CompilerUtils.class);
    private static final AtomicLong CLASS_ID = new AtomicLong();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final String PACKAGE_PREFIX = "io.trino.$gen.";
    private static final int MAX_SYMBOL_TABLE_ENTRY_LENGTH = 65535;
    private static final int MAX_CLASS_NAME_LENGTH = 57343;

    private CompilerUtils() {
    }

    public static ParameterizedType makeClassName(String baseName, Optional<String> suffix) {
        String classNameSuffix = suffix.orElseGet(() -> Instant.now().atZone(ZoneOffset.UTC).format(TIMESTAMP_FORMAT));
        String classUniqueId = String.valueOf(CLASS_ID.incrementAndGet());
        int addedNameLength = PACKAGE_PREFIX.length() + 2 + classNameSuffix.length() + classUniqueId.length();
        if (baseName.length() + addedNameLength > 57343) {
            baseName = baseName.substring(0, 57343 - addedNameLength);
        }
        String className = baseName + "_" + classNameSuffix + "_" + classUniqueId;
        return ParameterizedType.typeFromJavaClassName((String)(PACKAGE_PREFIX + BytecodeUtils.toJavaIdentifierString((String)className)));
    }

    public static ParameterizedType makeClassName(String baseName) {
        return CompilerUtils.makeClassName(baseName, Optional.empty());
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, Map<Long, MethodHandle> callSiteBindings, ClassLoader parentClassLoader) {
        return CompilerUtils.defineClass(classDefinition, superType, new DynamicClassLoader(parentClassLoader, callSiteBindings));
    }

    public static <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType, DynamicClassLoader classLoader) {
        log.debug("Defining class: %s", new Object[]{classDefinition.getName()});
        try {
            return ClassGenerator.classGenerator((DynamicClassLoader)classLoader).defineClass(classDefinition, superType);
        }
        catch (MethodTooLargeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_EXCEEDED_COMPILER_LIMIT, "Query exceeded maximum method size.", (Throwable)e);
        }
    }
}

