/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;

public interface JdbcMetadata
extends ConnectorMetadata {
    public JdbcTableHandle getTableHandle(ConnectorSession var1, PreparedQuery var2);

    public JdbcProcedureHandle getProcedureHandle(ConnectorSession var1, JdbcProcedureHandle.ProcedureQuery var2);

    public void rollback();

    public static List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcClient jdbcClient, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return tableHandle.getColumns().get();
        }
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        Verify.verify((boolean)tableHandle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(tableHandle), (Object[])new Object[0]);
        SchemaTableName schemaTableName = tableHandle.getRequiredNamedRelation().getSchemaTableName();
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        return jdbcClient.getColumns(session, schemaTableName, remoteTableName);
    }
}

