/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcConnectionUrlParser;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcInstrumenterFactory;
import io.opentelemetry.instrumentation.jdbc.internal.OpenTelemetryConnection;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class OpenTelemetryDriver
implements Driver {
    static final OpenTelemetryDriver INSTANCE = new OpenTelemetryDriver();
    private volatile OpenTelemetry openTelemetry = OpenTelemetry.noop();
    private static final int MAJOR_VERSION;
    private static final int MINOR_VERSION;
    private static final String URL_PREFIX = "jdbc:otel:";
    private static final AtomicBoolean REGISTERED;
    private static final List<Driver> DRIVER_CANDIDATES;

    public static void register() throws SQLException {
        if (!REGISTERED.compareAndSet(false, true)) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        DriverManager.registerDriver(INSTANCE);
    }

    public static void deregister() throws SQLException {
        if (!REGISTERED.compareAndSet(true, false)) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(INSTANCE);
    }

    public static boolean isRegistered() {
        return REGISTERED.get();
    }

    public static void addDriverCandidate(Driver driver) {
        if (driver != null) {
            DRIVER_CANDIDATES.add(driver);
        }
    }

    public static boolean removeDriverCandidate(Driver driver) {
        return DRIVER_CANDIDATES.remove(driver);
    }

    static Driver findDriver(String realUrl) {
        Driver driver = null;
        if (!DRIVER_CANDIDATES.isEmpty()) {
            driver = OpenTelemetryDriver.findDriver(realUrl, DRIVER_CANDIDATES);
        }
        if (driver == null) {
            driver = OpenTelemetryDriver.findDriver(realUrl, Collections.list(DriverManager.getDrivers()));
        }
        if (driver == null) {
            throw new IllegalStateException("Unable to find a driver that accepts url: " + realUrl);
        }
        return driver;
    }

    private static Driver findDriver(String realUrl, Collection<Driver> drivers) {
        for (Driver candidate : drivers) {
            try {
                if (candidate instanceof OpenTelemetryDriver || !candidate.acceptsURL(realUrl)) continue;
                return candidate;
            }
            catch (SQLException sQLException) {
            }
        }
        return null;
    }

    private static String extractRealUrl(String url) {
        return url.startsWith(URL_PREFIX) ? url.replace(URL_PREFIX, "jdbc:") : url;
    }

    private static int[] parseInstrumentationVersion() {
        String version = EmbeddedInstrumentationProperties.findVersion((String)"io.opentelemetry.jdbc");
        if (version == null) {
            return new int[]{0, 0};
        }
        String[] parts = version.split("\\.");
        if (parts.length >= 2) {
            try {
                int majorVersion = Integer.parseInt(parts[0]);
                int minorVersion = Integer.parseInt(parts[1]);
                return new int[]{majorVersion, minorVersion};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{0, 0};
    }

    public static void install(OpenTelemetry openTelemetry) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!(driver instanceof OpenTelemetryDriver)) continue;
            OpenTelemetryDriver openTelemetryDriver = (OpenTelemetryDriver)driver;
            openTelemetryDriver.setOpenTelemetry(openTelemetry);
        }
    }

    public void setOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @Override
    @Nullable
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("url is required");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        String realUrl = OpenTelemetryDriver.extractRealUrl(url);
        Driver wrappedDriver = OpenTelemetryDriver.findDriver(realUrl);
        Connection connection = wrappedDriver.connect(realUrl, info);
        DbInfo dbInfo = JdbcConnectionUrlParser.parse(realUrl, info);
        Instrumenter<DbRequest, Void> statementInstrumenter = JdbcInstrumenterFactory.createStatementInstrumenter(this.openTelemetry);
        boolean captureQueryParameters = JdbcInstrumenterFactory.captureQueryParameters();
        Instrumenter<DbRequest, Void> transactionInstrumenter = JdbcInstrumenterFactory.createTransactionInstrumenter(this.openTelemetry);
        return OpenTelemetryConnection.create(connection, dbInfo, statementInstrumenter, transactionInstrumenter, captureQueryParameters);
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        return url.startsWith(URL_PREFIX) && url.length() > URL_PREFIX.length();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("url is required");
        }
        String realUrl = OpenTelemetryDriver.extractRealUrl(url);
        Driver wrappedDriver = OpenTelemetryDriver.findDriver(realUrl);
        return wrappedDriver.getPropertyInfo(realUrl, info);
    }

    @Override
    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    static {
        REGISTERED = new AtomicBoolean();
        DRIVER_CANDIDATES = new CopyOnWriteArrayList<Driver>();
        try {
            int[] version = OpenTelemetryDriver.parseInstrumentationVersion();
            MAJOR_VERSION = version[0];
            MINOR_VERSION = version[1];
            OpenTelemetryDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

