/*
 * Decompiled with CFR 0.152.
 */
package io.trino.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate-service-descriptor", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ServiceDescriptorGenerator
extends AbstractMojo {
    private static final String LS = System.lineSeparator();
    private static final DateFormat OUTPUT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    @Parameter(defaultValue="io.trino.spi.Plugin")
    private String pluginClassName;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}-services.jar")
    private File servicesJar;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/services")
    private File servicesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        Class<?> pluginClass;
        block25: {
            List<Class<?>> pluginClasses;
            File servicesFile = new File(this.servicesDirectory, this.pluginClassName);
            if (servicesFile.exists()) {
                throw new MojoExecutionException(String.format("%n%nExisting service descriptor for %s found in output directory.", this.pluginClassName));
            }
            try {
                URLClassLoader loader = this.createClassloaderFromCompileTimeDependencies();
                pluginClasses = this.findPluginImplementations(loader);
            }
            catch (Exception e) {
                throw new MojoExecutionException(String.format("%n%nError scanning for classes implementing %s.", this.pluginClassName), e);
            }
            if (pluginClasses.isEmpty()) {
                throw new MojoExecutionException(String.format("%n%nYou must have at least one class that implements %s.", this.pluginClassName));
            }
            if (pluginClasses.size() > 1) {
                StringBuilder sb = new StringBuilder();
                Iterator<Class<?>> iterator = pluginClasses.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw new MojoExecutionException(String.format("%n%nYou have more than one class that implements %s:%n%n%s%nYou can only have one per plugin project.", this.pluginClassName, sb));
                    }
                    Class<?> pluginClass2 = iterator.next();
                    sb.append(pluginClass2.getName()).append(LS);
                }
            }
            pluginClass = pluginClasses.get(0);
            byte[] servicesFileData = (String.valueOf(pluginClass.getName()) + "\n").getBytes(StandardCharsets.UTF_8);
            try {
                Throwable throwable = null;
                Object var6_11 = null;
                try {
                    FileOutputStream out = new FileOutputStream(this.servicesJar);
                    try {
                        try (JarOutputStream jar = new JarOutputStream(out);){
                            JarEntry jarEntry = new JarEntry("META-INF/services/" + this.pluginClassName);
                            if (this.outputTimestamp != null && !this.outputTimestamp.isBlank()) {
                                try {
                                    jarEntry.setTime(OUTPUT_DATE_FORMAT.parse(this.outputTimestamp).getTime());
                                }
                                catch (ParseException e) {
                                    throw new RuntimeException("Could not parse outputTimestamp: " + this.outputTimestamp, e);
                                }
                            }
                            jar.putNextEntry(jarEntry);
                            jar.write(servicesFileData);
                            jar.closeEntry();
                        }
                        if (out == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    out.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write services JAR file.", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)String.format("Wrote %s to %s", pluginClass.getName(), this.servicesJar));
    }

    private URLClassLoader createClassloaderFromCompileTimeDependencies() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.classesDirectory.toURI().toURL());
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    private List<Class<?>> findPluginImplementations(URLClassLoader searchRealm) throws IOException, MojoExecutionException {
        ArrayList implementations = new ArrayList();
        List classes = FileUtils.getFileNames((File)this.classesDirectory, (String)"**/*.class", null, (boolean)false);
        for (String classPath : classes) {
            String className = classPath.substring(0, classPath.length() - 6).replace(File.separatorChar, '.');
            try {
                Class<?> pluginClass = searchRealm.loadClass(this.pluginClassName);
                Class<?> clazz = searchRealm.loadClass(className);
                if (!ServiceDescriptorGenerator.isImplementation(clazz, pluginClass)) continue;
                implementations.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Failed to load class.", (Exception)e);
            }
        }
        return implementations;
    }

    private static void mkdirs(File file) throws MojoExecutionException {
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new MojoExecutionException(String.format("%n%nFailed to create directory: %s", file));
        }
    }

    private static boolean isImplementation(Class<?> clazz, Class<?> pluginClass) {
        return pluginClass.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers());
    }
}

