/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory.context;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.LocalMemoryContext;
import java.util.Objects;

public class ThresholdLocalMemoryContext
implements LocalMemoryContext {
    public static final long DEFAULT_SYNC_THRESHOLD = 65536L;
    private final LocalMemoryContext delegate;
    private final long syncThreshold;
    private long syncedBytes;
    private long currentBytes;

    public ThresholdLocalMemoryContext(LocalMemoryContext delegate) {
        this(delegate, 65536L);
    }

    public ThresholdLocalMemoryContext(LocalMemoryContext delegate, long syncThreshold) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Preconditions.checkArgument((syncThreshold > 0L ? 1 : 0) != 0, (Object)"syncThreshold must be greater than 0");
        this.syncThreshold = syncThreshold;
    }

    @Override
    public long getBytes() {
        return this.currentBytes;
    }

    @Override
    public ListenableFuture<Void> setBytes(long bytes) {
        if (bytes < this.syncedBytes || bytes - this.syncedBytes > this.syncThreshold) {
            this.currentBytes = bytes;
            this.syncedBytes = bytes;
            return this.delegate.setBytes(bytes);
        }
        this.currentBytes = bytes;
        return Futures.immediateVoidFuture();
    }

    @Override
    public boolean trySetBytes(long bytes) {
        if (bytes < this.syncedBytes || bytes - this.syncedBytes > this.syncThreshold) {
            if (this.delegate.trySetBytes(bytes)) {
                this.currentBytes = bytes;
                this.syncedBytes = bytes;
                return true;
            }
            return false;
        }
        this.currentBytes = bytes;
        return true;
    }

    @Override
    public void close() {
        this.delegate.close();
        this.currentBytes = 0L;
        this.syncedBytes = 0L;
    }

    public void sync() {
        this.delegate.setBytes(this.currentBytes);
        this.syncedBytes = this.currentBytes;
    }
}

