/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.memory.MemoryDataFragment;
import io.trino.plugin.memory.MemoryInsertTableHandle;
import io.trino.plugin.memory.MemoryOutputTableHandle;
import io.trino.plugin.memory.MemoryPagesStore;
import io.trino.spi.HostAddress;
import io.trino.spi.NodeManager;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class MemoryPageSinkProvider
implements ConnectorPageSinkProvider {
    private final MemoryPagesStore pagesStore;
    private final HostAddress currentHostAddress;

    @Inject
    public MemoryPageSinkProvider(MemoryPagesStore pagesStore, NodeManager nodeManager) {
        this(pagesStore, Objects.requireNonNull(nodeManager, "nodeManager is null").getCurrentNode().getHostAndPort());
    }

    @VisibleForTesting
    public MemoryPageSinkProvider(MemoryPagesStore pagesStore, HostAddress currentHostAddress) {
        this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
        this.currentHostAddress = Objects.requireNonNull(currentHostAddress, "currentHostAddress is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        MemoryOutputTableHandle memoryOutputTableHandle = (MemoryOutputTableHandle)outputTableHandle;
        long tableId = memoryOutputTableHandle.getTable();
        Preconditions.checkState((boolean)memoryOutputTableHandle.getActiveTableIds().contains(tableId));
        this.pagesStore.cleanUp(memoryOutputTableHandle.getActiveTableIds());
        this.pagesStore.initialize(tableId);
        return new MemoryPageSink(this.pagesStore, this.currentHostAddress, tableId);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        MemoryInsertTableHandle memoryInsertTableHandle = (MemoryInsertTableHandle)insertTableHandle;
        long tableId = memoryInsertTableHandle.getTable();
        Preconditions.checkState((boolean)memoryInsertTableHandle.getActiveTableIds().contains(tableId));
        this.pagesStore.cleanUp(memoryInsertTableHandle.getActiveTableIds());
        this.pagesStore.initialize(tableId);
        return new MemoryPageSink(this.pagesStore, this.currentHostAddress, tableId);
    }

    private static class MemoryPageSink
    implements ConnectorPageSink {
        private final MemoryPagesStore pagesStore;
        private final HostAddress currentHostAddress;
        private final long tableId;
        private long addedRows;

        public MemoryPageSink(MemoryPagesStore pagesStore, HostAddress currentHostAddress, long tableId) {
            this.pagesStore = Objects.requireNonNull(pagesStore, "pagesStore is null");
            this.currentHostAddress = Objects.requireNonNull(currentHostAddress, "currentHostAddress is null");
            this.tableId = tableId;
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.pagesStore.add(this.tableId, page);
            this.addedRows += (long)page.getPositionCount();
            return NOT_BLOCKED;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of((Object)new MemoryDataFragment(this.currentHostAddress, this.addedRows).toSlice()));
        }

        public void abort() {
        }
    }
}

