/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.base.MoreObjects;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class ColumnInfo {
    private final ColumnHandle handle;
    private final String name;
    private final Type type;
    private final Optional<String> comment;

    public ColumnInfo(ColumnHandle handle, String name, Type type, Optional<String> comment) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public ColumnHandle getHandle() {
        return this.handle;
    }

    public String getName() {
        return this.name;
    }

    public ColumnMetadata getMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.type).setComment(this.comment).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("comment", this.comment).toString();
    }
}

