/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.log.Logger;
import io.airlift.testing.Closeables;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MemoryQueryRunner {
    private static final String CATALOG = "memory";

    private MemoryQueryRunner() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String[] args) throws Exception {
        DistributedQueryRunner queryRunner = ((Builder)((Builder)((Builder)((Builder)MemoryQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).addExtraProperty("sql.path", "memory.functions")).addExtraProperty("sql.default-function-catalog", CATALOG)).addExtraProperty("sql.default-function-schema", "functions")).setInitialTables(TpchTable.getTables()).build();
        Logger log = Logger.get(MemoryQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static class Builder
    extends DistributedQueryRunner.Builder<Builder> {
        private ImmutableMap.Builder<String, String> memoryProperties = ImmutableMap.builder();
        private List<TpchTable<?>> initialTables = ImmutableList.of();

        protected Builder() {
            super(TestingSession.testSessionBuilder().setCatalog(MemoryQueryRunner.CATALOG).setSchema("default").build());
        }

        @CanIgnoreReturnValue
        public Builder setMemoryProperties(Map<String, String> memoryProperties) {
            this.memoryProperties = ImmutableMap.builder().putAll(Objects.requireNonNull(memoryProperties, "memoryProperties is null"));
            return (Builder)this.self();
        }

        @CanIgnoreReturnValue
        public Builder addMemoryProperty(String key, String value) {
            this.memoryProperties.put((Object)key, (Object)value);
            return (Builder)this.self();
        }

        @CanIgnoreReturnValue
        public Builder setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return (Builder)this.self();
        }

        public DistributedQueryRunner build() throws Exception {
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new MemoryPlugin());
                queryRunner.createCatalog(MemoryQueryRunner.CATALOG, MemoryQueryRunner.CATALOG, (Map)this.memoryProperties.buildOrThrow());
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
                QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", this.initialTables);
                return queryRunner;
            }
            catch (Exception e) {
                Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
                throw e;
            }
        }
    }

    public static final class MemoryQueryRunnerWithTaskRetries {
        private MemoryQueryRunnerWithTaskRetries() {
        }

        public static void main(String[] args) throws Exception {
            Path exchangeManagerDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
            ImmutableMap exchangeManagerProperties = ImmutableMap.builder().put((Object)"exchange.base-directories", (Object)exchangeManagerDirectory.toAbsolutePath().toString()).buildOrThrow();
            DistributedQueryRunner queryRunner = ((Builder)((Builder)((Builder)MemoryQueryRunner.builder().addCoordinatorProperty("http-server.http.port", "8080")).setExtraProperties((Map)ImmutableMap.builder().put((Object)"retry-policy", (Object)"TASK").put((Object)"fault-tolerant-execution-task-memory", (Object)"1GB").buildOrThrow())).setAdditionalSetup(runner -> {
                runner.installPlugin((Plugin)new FileSystemExchangePlugin());
                runner.loadExchangeManager("filesystem", (Map)exchangeManagerProperties);
            })).setInitialTables(TpchTable.getTables()).build();
            Logger log = Logger.get(MemoryQueryRunner.class);
            log.info("======== SERVER STARTED ========");
            log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
        }
    }
}

