/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.memory.MemoryConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

final class TestMemoryConfig {
    TestMemoryConfig() {
    }

    @Test
    void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MemoryConfig)ConfigAssertions.recordDefaults(MemoryConfig.class)).setSplitsPerNode(Runtime.getRuntime().availableProcessors()).setMaxDataPerNode(DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setEnableLazyDynamicFiltering(true));
    }

    @Test
    void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"memory.splits-per-node", (Object)"100").put((Object)"memory.max-data-per-node", (Object)"1GB").put((Object)"memory.enable-lazy-dynamic-filtering", (Object)"false").buildOrThrow();
        MemoryConfig expected = new MemoryConfig().setSplitsPerNode(100).setMaxDataPerNode(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setEnableLazyDynamicFiltering(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

