/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.plugin.memory.MemoryConfig;
import io.trino.plugin.memory.MemoryInsertTableHandle;
import io.trino.plugin.memory.MemoryOutputTableHandle;
import io.trino.plugin.memory.MemoryPageSinkProvider;
import io.trino.plugin.memory.MemoryPagesStore;
import io.trino.plugin.memory.MemoryTransactionHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingPageSinkId;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestMemoryPagesStore {
    private static final int POSITIONS_PER_PAGE = 0;
    private MemoryPagesStore pagesStore;
    private MemoryPageSinkProvider pageSinkProvider;

    @BeforeEach
    public void setUp() {
        this.pagesStore = new MemoryPagesStore(new MemoryConfig().setMaxDataPerNode(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        this.pageSinkProvider = new MemoryPageSinkProvider(this.pagesStore, HostAddress.fromString((String)"localhost:8080"));
    }

    @Test
    public void testCreateEmptyTable() {
        this.createTable(0L, 0L);
        Assertions.assertThat((List)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, new int[]{0}, List.of(IntegerType.INTEGER), 0L, OptionalLong.empty(), OptionalDouble.empty())).isEqualTo((Object)ImmutableList.of());
    }

    @Test
    public void testInsertPage() {
        this.createTable(0L, 0L);
        this.insertToTable(0L, 0L);
        Assertions.assertThat((List)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, new int[]{0}, List.of(IntegerType.INTEGER), 0L, OptionalLong.empty(), OptionalDouble.empty())).hasSize(1);
    }

    @Test
    public void testInsertPageWithoutCreate() {
        this.insertToTable(0L, 0L);
        Assertions.assertThat((List)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, new int[]{0}, List.of(IntegerType.INTEGER), 0L, OptionalLong.empty(), OptionalDouble.empty())).hasSize(1);
    }

    @Test
    public void testReadFromUnknownTable() {
        Assertions.assertThatThrownBy(() -> this.pagesStore.getPages(Long.valueOf(0L), 0, 1, new int[]{0}, List.of(IntegerType.INTEGER), 0L, OptionalLong.empty(), OptionalDouble.empty())).isInstanceOf(TrinoException.class);
    }

    @Test
    public void testTryToReadFromEmptyTable() {
        this.createTable(0L, 0L);
        Assertions.assertThat((List)this.pagesStore.getPages(Long.valueOf(0L), 0, 1, new int[]{0}, List.of(IntegerType.INTEGER), 0L, OptionalLong.empty(), OptionalDouble.empty())).isEqualTo((Object)ImmutableList.of());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.pagesStore.getPages(Long.valueOf(0L), 0, 1, new int[]{0}, List.of(IntegerType.INTEGER), 42L, OptionalLong.empty(), OptionalDouble.empty())).isInstanceOf(TrinoException.class)).hasMessageMatching("Expected to find.*");
    }

    @Test
    public void testCleanUp() {
        this.createTable(0L, 0L);
        this.createTable(1L, 0L, 1L);
        this.createTable(2L, 0L, 1L, 2L);
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(0L))).isTrue();
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(1L))).isTrue();
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(2L))).isTrue();
        this.insertToTable(1L, 0L, 1L);
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(0L))).isTrue();
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(1L))).isTrue();
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(2L))).isTrue();
        this.insertToTable(2L, 0L, 2L);
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(0L))).isTrue();
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(1L))).isFalse();
        Assertions.assertThat((boolean)this.pagesStore.contains(Long.valueOf(2L))).isTrue();
    }

    @Test
    public void testMemoryLimitExceeded() {
        this.createTable(0L, 0L);
        this.insertToTable(0L, TestMemoryPagesStore.createOneMegaBytePage(), 0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.insertToTable(0L, TestMemoryPagesStore.createOneMegaBytePage(), 0L)).isInstanceOf(TrinoException.class)).hasMessageMatching("Memory limit.*");
    }

    private void insertToTable(long tableId, Long ... activeTableIds) {
        this.insertToTable(tableId, TestMemoryPagesStore.createPage(), activeTableIds);
    }

    private void insertToTable(long tableId, Page page, Long ... activeTableIds) {
        ConnectorPageSink pageSink = this.pageSinkProvider.createPageSink((ConnectorTransactionHandle)MemoryTransactionHandle.INSTANCE, TestingConnectorSession.SESSION, TestMemoryPagesStore.createMemoryInsertTableHandle(tableId, activeTableIds), (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
        pageSink.appendPage(page);
        pageSink.finish();
    }

    private void createTable(long tableId, Long ... activeTableIds) {
        ConnectorPageSink pageSink = this.pageSinkProvider.createPageSink((ConnectorTransactionHandle)MemoryTransactionHandle.INSTANCE, TestingConnectorSession.SESSION, TestMemoryPagesStore.createMemoryOutputTableHandle(tableId, activeTableIds), (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
        pageSink.finish();
    }

    private static ConnectorOutputTableHandle createMemoryOutputTableHandle(long tableId, Long ... activeTableIds) {
        return new MemoryOutputTableHandle(tableId, (Set)ImmutableSet.copyOf((Object[])activeTableIds));
    }

    private static ConnectorInsertTableHandle createMemoryInsertTableHandle(long tableId, Long[] activeTableIds) {
        return new MemoryInsertTableHandle(tableId, MemoryInsertTableHandle.InsertMode.APPEND, (Set)ImmutableSet.copyOf((Object[])activeTableIds));
    }

    private static Page createPage() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(0);
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        return new Page(0, new Block[]{blockBuilder.build()});
    }

    private static Page createOneMegaBytePage() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(0);
        while (blockBuilder.getRetainedSizeInBytes() < 0x100000L) {
            BigintType.BIGINT.writeLong(blockBuilder, 42L);
        }
        return new Page(0, new Block[]{blockBuilder.build()});
    }
}

