/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.memory.MemoryConnector;
import io.trino.plugin.memory.MemoryModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class MemoryConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "memory";
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MemoryModule(context.getTypeManager(), context.getNodeManager())});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(MemoryConnector.class);
    }
}

