/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.trino.Session;
import io.trino.execution.QueryStats;
import io.trino.operator.OperatorStats;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.memory.MemoryQueryRunner;
import io.trino.spi.QueryId;
import io.trino.spi.metrics.Count;
import io.trino.spi.metrics.Metric;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestMemoryConnectorTest
extends BaseConnectorTest {
    private static final int LINEITEM_COUNT = 60175;
    private static final int ORDERS_COUNT = 15000;
    private static final int PART_COUNT = 2000;
    private static final int CUSTOMER_COUNT = 1500;

    protected QueryRunner createQueryRunner() throws Exception {
        return ((MemoryQueryRunner.Builder)MemoryQueryRunner.builder().addExtraProperties((Map)ImmutableMap.builder().put((Object)"enable-large-dynamic-filters", (Object)"false").put((Object)"dynamic-filtering.small.max-distinct-values-per-driver", (Object)"100").put((Object)"dynamic-filtering.small.range-row-limit-per-driver", (Object)"100").put((Object)"dynamic-filtering.large.max-distinct-values-per-driver", (Object)"100").put((Object)"dynamic-filtering.large.range-row-limit-per-driver", (Object)"100000").put((Object)"dynamic-filtering.small-partitioned.max-distinct-values-per-driver", (Object)"100").put((Object)"dynamic-filtering.small-partitioned.range-row-limit-per-driver", (Object)"200").put((Object)"dynamic-filtering.large-partitioned.max-distinct-values-per-driver", (Object)"100").put((Object)"dynamic-filtering.large-partitioned.range-row-limit-per-driver", (Object)"100000").put((Object)"optimizer.rewrite-filtering-semi-join-to-inner-join", (Object)"false").put((Object)"sql.path", (Object)"memory.functions").put((Object)"sql.default-function-catalog", (Object)"memory").put((Object)"sql.default-function-schema", (Object)"functions").buildOrThrow())).setInitialTables((Iterable<TpchTable<?>>)ImmutableSet.builder().addAll((Iterable)REQUIRED_TPCH_TABLES).add((Object)TpchTable.PART).add((Object)TpchTable.LINE_ITEM).build()).build();
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_TRUNCATE -> true;
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_POSITION, TestingConnectorBehavior.SUPPORTS_ADD_FIELD, TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_DELETE, TestingConnectorBehavior.SUPPORTS_DEREFERENCE_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_DROP_COLUMN, TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_MERGE, TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_RENAME_FIELD, TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_UPDATE -> false;
            case TestingConnectorBehavior.SUPPORTS_CREATE_FUNCTION -> true;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected TestTable createTableWithDefaultColumns() {
        return (TestTable)Assumptions.abort((String)"Memory connector does not support column default values");
    }

    @Test
    public void testCreateTableWhenTableIsAlreadyCreated() {
        String createTableSql = "CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertUpdate(createTableSql)).isInstanceOf(RuntimeException.class)).hasMessage("line 1:1: Destination table 'memory.default.nation' already exists");
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select AS SELECT * FROM tpch.tiny.nation", "SELECT count(*) FROM nation");
        this.assertQuery("SELECT * FROM test_select ORDER BY nationkey", "SELECT * FROM nation ORDER BY nationkey");
        this.assertUpdate("INSERT INTO test_select SELECT * FROM tpch.tiny.nation", 25L);
        this.assertUpdate("INSERT INTO test_select SELECT * FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM test_select")).isEqualTo((Object)75L);
    }

    @Test
    public void testCustomMetricsScanFilter() {
        Metrics metrics = this.collectCustomMetrics("SELECT partkey FROM part WHERE partkey % 1000 > 0");
        Assertions.assertThat((Map)metrics.getMetrics()).containsEntry((Object)"rows", (Object)new LongCount(2000L));
        Assertions.assertThat((Map)metrics.getMetrics()).containsEntry((Object)"started", (Object)((Metric)metrics.getMetrics().get("finished")));
        Assertions.assertThat((long)((Count)metrics.getMetrics().get("finished")).getTotal()).isGreaterThan(0L);
    }

    @Test
    public void testCustomMetricsScanOnly() {
        Metrics metrics = this.collectCustomMetrics("SELECT partkey FROM part");
        Assertions.assertThat((Map)metrics.getMetrics()).containsEntry((Object)"rows", (Object)new LongCount(2000L));
        Assertions.assertThat((Map)metrics.getMetrics()).containsEntry((Object)"started", (Object)((Metric)metrics.getMetrics().get("finished")));
        Assertions.assertThat((long)((Count)metrics.getMetrics().get("finished")).getTotal()).isGreaterThan(0L);
    }

    @Test
    public void testExplainCustomMetricsScanOnly() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT partkey FROM part", new String[]{"'rows' = LongCount\\{total=2000}"});
    }

    @Test
    public void testExplainCustomMetricsScanFilter() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT partkey FROM part WHERE partkey % 1000 > 0", new String[]{"'rows' = LongCount\\{total=2000}"});
    }

    private Metrics collectCustomMetrics(String sql) {
        QueryRunner runner = this.getQueryRunner();
        QueryRunner.MaterializedResultWithPlan result = runner.executeWithPlan(this.getSession(), sql);
        return runner.getCoordinator().getQueryManager().getFullQueryInfo(result.queryId()).getQueryStats().getOperatorSummaries().stream().map(OperatorStats::getConnectorMetrics).reduce(Metrics.EMPTY, Metrics::mergeWith);
    }

    @Test
    @Timeout(value=30L)
    public void testPhysicalInputPositions() {
        QueryRunner.MaterializedResultWithPlan result = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), "SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey AND supplier.name = 'Supplier#000000001'");
        Assertions.assertThat((int)result.result().getRowCount()).isEqualTo(615);
        OperatorStats probeStats = (OperatorStats)TestMemoryConnectorTest.getScanOperatorStats((QueryRunner)this.getDistributedQueryRunner(), result.queryId()).stream().findFirst().orElseThrow();
        Assertions.assertThat((long)probeStats.getInputPositions()).isEqualTo(615L);
        Assertions.assertThat((long)probeStats.getPhysicalInputPositions()).isEqualTo(60175L);
    }

    @Test
    @Timeout(value=30L)
    public void testJoinDynamicFilteringNone() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertDynamicFiltering("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice < 0", this.noJoinReordering(joinDistributionType), 0, 0, 15000);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testJoinLargeBuildSideDynamicFiltering() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            String sql = "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey and orders.custkey BETWEEN 300 AND 700";
            int expectedRowCount = 15793;
            this.assertDynamicFiltering(sql, this.noJoinReordering(joinDistributionType), expectedRowCount, 60175, 15000);
            this.assertDynamicFiltering(sql, this.withLargeDynamicFilters(joinDistributionType), expectedRowCount, 60139, 15000);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testJoinDynamicFilteringSingleValue() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            Assertions.assertThat((Object)this.computeScalar("SELECT orderkey FROM orders WHERE comment = 'nstructions sleep furiously among '")).isEqualTo((Object)1L);
            Assertions.assertThat((Object)this.computeScalar("SELECT COUNT() FROM lineitem WHERE orderkey = 1")).isEqualTo((Object)6L);
            Assertions.assertThat((Object)this.computeScalar("SELECT partkey FROM part WHERE comment = 'onic deposits'")).isEqualTo((Object)1552L);
            Assertions.assertThat((Object)this.computeScalar("SELECT COUNT() FROM lineitem WHERE partkey = 1552")).isEqualTo((Object)39L);
            this.assertDynamicFiltering("SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.comment = 'nstructions sleep furiously among '", this.noJoinReordering(joinDistributionType), 6, 6, 15000);
            this.assertDynamicFiltering("SELECT l.comment FROM  lineitem l, part p WHERE p.partkey = l.partkey AND p.comment = 'onic deposits'", this.noJoinReordering(joinDistributionType), 39, 39, 2000);
        }
    }

    @Test
    public void testJoinDynamicFilteringImplicitCoercion() {
        this.assertUpdate("CREATE TABLE coerce_test AS SELECT CAST(orderkey as INT) orderkey_int FROM tpch.tiny.lineitem", "SELECT count(*) FROM lineitem");
        this.assertDynamicFiltering("SELECT * FROM coerce_test l JOIN orders o ON l.orderkey_int = o.orderkey AND o.comment = 'nstructions sleep furiously among '", this.noJoinReordering(OptimizerConfig.JoinDistributionType.BROADCAST), 6, 6, 15000);
    }

    @Test
    @Timeout(value=30L)
    public void testJoinDynamicFilteringBlockProbeSide() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertDynamicFiltering("SELECT l.comment FROM  lineitem l, orders o WHERE l.orderkey = o.orderkey AND o.comment = 'nstructions sleep furiously among '", this.noJoinReordering(joinDistributionType), 6, 6, 15000);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinDynamicFilteringNone() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertDynamicFiltering("SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.totalprice < 0)", this.noJoinReordering(joinDistributionType), 0, 0, 15000);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinLargeBuildSideDynamicFiltering() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            String sql = "SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.custkey BETWEEN 300 AND 700)";
            int expectedRowCount = 15793;
            this.assertDynamicFiltering(sql, this.noJoinReordering(joinDistributionType), expectedRowCount, 60175, 15000);
            this.assertDynamicFiltering(sql, this.withLargeDynamicFilters(joinDistributionType), expectedRowCount, 60139, 15000);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinDynamicFilteringSingleValue() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertDynamicFiltering("SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM orders WHERE orders.comment = 'nstructions sleep furiously among ')", this.noJoinReordering(joinDistributionType), 6, 6, 15000);
            this.assertDynamicFiltering("SELECT l.comment FROM lineitem l WHERE l.partkey IN (SELECT p.partkey FROM part p WHERE p.comment = 'onic deposits')", this.noJoinReordering(joinDistributionType), 39, 39, 2000);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinDynamicFilteringBlockProbeSide() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertDynamicFiltering("SELECT t.comment FROM (SELECT * FROM lineitem l WHERE l.orderkey IN (SELECT o.orderkey FROM orders o WHERE o.comment = 'nstructions sleep furiously among ')) t WHERE t.partkey IN (SELECT p.partkey FROM part p WHERE p.comment = 'onic deposits')", this.noJoinReordering(joinDistributionType), 1, 1, 15000, 2000);
        }
    }

    @Test
    public void testCrossJoinDynamicFiltering() {
        this.assertUpdate("DROP TABLE IF EXISTS probe");
        this.assertUpdate("CREATE TABLE probe (k VARCHAR, v INTEGER)");
        this.assertUpdate("INSERT INTO probe VALUES ('a', 0), ('b', 1), ('c', 2), ('d', 3), ('e', NULL)", 5L);
        this.assertUpdate("DROP TABLE IF EXISTS build");
        this.assertUpdate("CREATE TABLE build (vmin INTEGER, vmax INTEGER)");
        this.assertUpdate("INSERT INTO build VALUES (1, 2), (NULL, NULL)", 2L);
        Session session = this.noJoinReordering(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin", session, 3, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin", session, 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v <= vmax", session, 3, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v < vmax", session, 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin AND v < vmax", session, 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin AND v <= vmax", session, 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin AND v < vmax", session, 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v > vmin AND vmax < 0", session, 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin AND vmax", session, 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin AND v <= vmax", session, 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin AND vmax", session, 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin AND v <= vmax", session, 2, 2, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin AND vmax - 1", session, 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin + 1 AND vmax", session, 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v BETWEEN vmin + 1 AND vmax - 1", session, 0, 5, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin AND vmax - 1", session, 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin + 1 AND vmax", session, 1, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v BETWEEN vmin + 1 AND vmax - 1", session, 0, 5, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin AND v <= vmax - 1", session, 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin + 1 AND v <= vmax", session, 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v >= vmin + 1 AND v <= vmax - 1", session, 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin AND v <= vmax - 1", session, 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin + 1 AND v <= vmax", session, 1, 1, 2);
        this.assertDynamicFiltering("SELECT * FROM probe, build WHERE v >= vmin + 1 AND v <= vmax - 1", session, 0, 0, 2);
        this.assertDynamicFiltering("SELECT * FROM probe WHERE v <= (SELECT max(vmax) FROM build)", session, 3, 3, 2);
        this.assertDynamicFiltering("SELECT * FROM probe JOIN build ON v IS NOT DISTINCT FROM vmin", session, 2, 2, 2);
    }

    @Test
    public void testIsNotDistinctFromNaN() {
        this.assertUpdate("DROP TABLE IF EXISTS probe_nan");
        this.assertUpdate("CREATE TABLE probe_nan (v DOUBLE)");
        this.assertUpdate("INSERT INTO probe_nan VALUES 0, 1, 2, NULL, nan()", 5L);
        this.assertUpdate("DROP TABLE IF EXISTS build_nan");
        this.assertUpdate("CREATE TABLE build_nan (v DOUBLE)");
        this.assertUpdate("INSERT INTO build_nan VALUES 1, NULL, nan()", 3L);
        Session session = this.noJoinReordering(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.assertDynamicFiltering("SELECT * FROM probe_nan p JOIN build_nan b ON p.v IS NOT DISTINCT FROM b.v", session, 3, 5, 3);
        this.assertDynamicFiltering("SELECT * FROM probe_nan p JOIN build_nan b ON p.v = b.v", session, 1, 1, 3);
    }

    @Test
    public void testCrossJoinLargeBuildSideDynamicFiltering() {
        this.assertDynamicFiltering("SELECT * FROM orders o, customer c WHERE o.custkey < c.custkey AND c.name < 'Customer#000001000' AND o.custkey > 1000", this.noJoinReordering(OptimizerConfig.JoinDistributionType.BROADCAST), 0, 15000, 1500);
    }

    @Test
    @Timeout(value=30L)
    public void testJoinDynamicFilteringMultiJoin() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            this.assertUpdate("DROP TABLE IF EXISTS t0");
            this.assertUpdate("DROP TABLE IF EXISTS t1");
            this.assertUpdate("DROP TABLE IF EXISTS t2");
            this.assertUpdate("CREATE TABLE t0 (k0 integer, v0 real)");
            this.assertUpdate("CREATE TABLE t1 (k1 integer, v1 real)");
            this.assertUpdate("CREATE TABLE t2 (k2 integer, v2 real)");
            this.assertUpdate("INSERT INTO t0 VALUES (1, 1.0)", 1L);
            this.assertUpdate("INSERT INTO t1 VALUES (1, 2.0)", 1L);
            this.assertUpdate("INSERT INTO t2 VALUES (1, 3.0)", 1L);
            this.assertQuery(this.noJoinReordering(joinDistributionType), "SELECT k0, k1, k2 FROM t0, t1, t2 WHERE (k0 = k1) AND (k0 = k2) AND (v0 + v1 = v2)", "SELECT 1, 1, 1");
        }
    }

    private void assertDynamicFiltering(@Language(value="SQL") String selectQuery, Session session, int expectedRowCount, int ... expectedOperatorRowsRead) {
        QueryRunner.MaterializedResultWithPlan result = this.getDistributedQueryRunner().executeWithPlan(session, selectQuery);
        Assertions.assertThat((int)result.result().getRowCount()).isEqualTo(expectedRowCount);
        Assertions.assertThat(TestMemoryConnectorTest.getOperatorRowsRead((QueryRunner)this.getDistributedQueryRunner(), result.queryId())).isEqualTo((Object)Ints.asList((int[])expectedOperatorRowsRead));
    }

    private Session withLargeDynamicFilters(OptimizerConfig.JoinDistributionType joinDistributionType) {
        return Session.builder((Session)this.noJoinReordering(joinDistributionType)).setSystemProperty("enable_large_dynamic_filters", "true").build();
    }

    private static List<Integer> getOperatorRowsRead(QueryRunner runner, QueryId queryId) {
        return (List)TestMemoryConnectorTest.getScanOperatorStats(runner, queryId).stream().map(OperatorStats::getInputPositions).map(Math::toIntExact).collect(ImmutableList.toImmutableList());
    }

    private static List<OperatorStats> getScanOperatorStats(QueryRunner runner, QueryId queryId) {
        QueryStats stats = runner.getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats();
        return (List)stats.getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().contains("Scan")).collect(ImmutableList.toImmutableList());
    }

    @Test
    public void testCreateTableWithNoData() {
        this.assertUpdate("CREATE TABLE test_empty (a BIGINT)");
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM test_empty")).isEqualTo((Object)0L);
        this.assertUpdate("INSERT INTO test_empty SELECT nationkey FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM test_empty")).isEqualTo((Object)25L);
    }

    @Test
    public void testCreateFilteredOutTable() {
        this.assertUpdate("CREATE TABLE filtered_out AS SELECT nationkey FROM tpch.tiny.nation WHERE nationkey < 0", "SELECT count(nationkey) FROM nation WHERE nationkey < 0");
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM filtered_out")).isEqualTo((Object)0L);
        this.assertUpdate("INSERT INTO filtered_out SELECT nationkey FROM tpch.tiny.nation", 25L);
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM filtered_out")).isEqualTo((Object)25L);
    }

    @Test
    public void testSelectFromEmptyTable() {
        this.assertUpdate("CREATE TABLE test_select_empty AS SELECT * FROM tpch.tiny.nation WHERE nationkey > 1000", "SELECT count(*) FROM nation WHERE nationkey > 1000");
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM test_select_empty")).isEqualTo((Object)0L);
    }

    @Test
    public void testSelectSingleRow() {
        this.assertQuery("SELECT * FROM tpch.tiny.nation WHERE nationkey = 1", "SELECT * FROM nation WHERE nationkey = 1");
    }

    @Test
    public void testSelectColumnsSubset() {
        this.assertQuery("SELECT nationkey, regionkey FROM tpch.tiny.nation ORDER BY nationkey", "SELECT nationkey, regionkey FROM nation ORDER BY nationkey");
    }

    @Test
    public void testCreateTableInNonDefaultSchema() {
        this.assertUpdate("CREATE SCHEMA schema1");
        this.assertUpdate("CREATE SCHEMA schema2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS"))).skippingTypesCheck().containsAll("VALUES 'default', 'information_schema', 'schema1', 'schema2'");
        this.assertUpdate("CREATE TABLE schema1.nation AS SELECT * FROM tpch.tiny.nation WHERE nationkey % 2 = 0", "SELECT count(*) FROM nation WHERE MOD(nationkey, 2) = 0");
        this.assertUpdate("CREATE TABLE schema2.nation AS SELECT * FROM tpch.tiny.nation WHERE nationkey % 2 = 1", "SELECT count(*) FROM nation WHERE MOD(nationkey, 2) = 1");
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM schema1.nation")).isEqualTo((Object)13L);
        Assertions.assertThat((Object)this.computeScalar("SELECT count(*) FROM schema2.nation")).isEqualTo((Object)12L);
        this.assertUpdate("DROP SCHEMA schema2 CASCADE");
        this.assertUpdate("DROP SCHEMA schema1 CASCADE");
    }

    @Test
    public void testCreateTableAndViewInNotExistSchema() {
        this.assertQueryFails("CREATE TABLE schema3.test_table3 (x date)", "Schema schema3 not found");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "schema3.test_table3")).isFalse();
        this.assertQueryFails("CREATE VIEW schema4.test_view4 AS SELECT 123 x", "Schema schema4 not found");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "schema4.test_view4")).isFalse();
        this.assertQueryFails("CREATE OR REPLACE VIEW schema5.test_view5 AS SELECT 123 x", "Schema schema5 not found");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "schema5.test_view5")).isFalse();
    }

    @Test
    public void testViews() {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertUpdate("CREATE VIEW test_view AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW test_view AS " + query);
        this.assertQueryFails("CREATE TABLE test_view (x date)", ".*Table 'memory.default.test_view' already exists");
        this.assertQueryFails("CREATE VIEW test_view AS SELECT 123 x", ".*View already exists: 'memory.default.test_view'");
        this.assertQuery("SELECT * FROM test_view", query);
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{"test_view"});
        this.assertUpdate("DROP VIEW test_view");
        this.assertQueryFails("DROP VIEW test_view", "line 1:1: View 'memory.default.test_view' does not exist");
    }

    @Test
    public void testRenameView() {
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        this.assertUpdate("CREATE VIEW test_view_to_be_renamed AS " + query);
        this.assertQueryFails("ALTER VIEW test_view_to_be_renamed RENAME TO memory.test_schema_not_exist.test_view_renamed", "Schema test_schema_not_exist not found");
        this.assertUpdate("ALTER VIEW test_view_to_be_renamed RENAME TO test_view_renamed");
        this.assertQuery("SELECT * FROM test_view_renamed", query);
        this.assertUpdate("CREATE SCHEMA test_different_schema");
        this.assertUpdate("ALTER VIEW test_view_renamed RENAME TO test_different_schema.test_view_renamed");
        this.assertQuery("SELECT * FROM test_different_schema.test_view_renamed", query);
        this.assertUpdate("DROP VIEW test_different_schema.test_view_renamed");
        this.assertUpdate("DROP SCHEMA test_different_schema");
    }

    @Test
    void testInsertAfterTruncate() {
        try (TestTable table = this.newTrinoTable("test_truncate", "AS SELECT 1 x");){
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 2");
        }
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return "NULL value not allowed for NOT NULL column: " + columnName;
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Unable to add NOT NULL column '.*' for non-empty table: .*");
    }
}

