/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.memory.MemoryMetadata;
import io.trino.plugin.memory.MemoryOutputTableHandle;
import io.trino.plugin.memory.MemoryTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.BigintType;
import io.trino.testing.QueryAssertions;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNodeManager;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestMemoryMetadata {
    @Test
    public void tableIsCreatedAfterCommits() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        TestMemoryMetadata.assertNoTables(metadata);
        SchemaTableName schemaTableName = new SchemaTableName("default", "temp_table");
        MemoryOutputTableHandle table = metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(schemaTableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty(), RetryMode.NO_RETRIES, false);
        metadata.finishCreateTable(TestingConnectorSession.SESSION, (ConnectorOutputTableHandle)table, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
        List tables = metadata.listTables(TestingConnectorSession.SESSION, Optional.empty());
        ((AbstractIntegerAssert)Assertions.assertThat((int)tables.size()).describedAs("Expected only one table", new Object[0])).isEqualTo(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((SchemaTableName)tables.get(0)).getTableName()).describedAs("Expected table with name 'temp_table'", new Object[0])).isEqualTo("temp_table");
    }

    @Test
    public void tableAlreadyExists() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        TestMemoryMetadata.assertNoTables(metadata);
        SchemaTableName test1Table = new SchemaTableName("default", "test1");
        SchemaTableName test2Table = new SchemaTableName("default", "test2");
        metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(test1Table, (List)ImmutableList.of()), SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(test1Table, (List)ImmutableList.of()), SaveMode.FAIL)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("Table [default.test1] already exists");
        ConnectorTableHandle test1TableHandle = metadata.getTableHandle(TestingConnectorSession.SESSION, test1Table, Optional.empty(), Optional.empty());
        metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(test2Table, (List)ImmutableList.of()), SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> metadata.renameTable(TestingConnectorSession.SESSION, test1TableHandle, test2Table)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("Table [default.test2] already exists");
    }

    @Test
    public void testActiveTableIds() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        TestMemoryMetadata.assertNoTables(metadata);
        SchemaTableName firstTableName = new SchemaTableName("default", "first_table");
        metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(firstTableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), SaveMode.FAIL);
        MemoryTableHandle firstTableHandle = (MemoryTableHandle)metadata.getTableHandle(TestingConnectorSession.SESSION, firstTableName, Optional.empty(), Optional.empty());
        long firstTableId = firstTableHandle.id();
        Assertions.assertThat((Collection)metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)firstTableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES).activeTableIds()).contains((Object[])new Long[]{firstTableId});
        SchemaTableName secondTableName = new SchemaTableName("default", "second_table");
        metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(secondTableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), SaveMode.FAIL);
        MemoryTableHandle secondTableHandle = (MemoryTableHandle)metadata.getTableHandle(TestingConnectorSession.SESSION, secondTableName, Optional.empty(), Optional.empty());
        long secondTableId = secondTableHandle.id();
        Assertions.assertThat((long)firstTableId).isNotEqualTo(secondTableId);
        Assertions.assertThat((Collection)metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)secondTableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES).activeTableIds()).contains((Object[])new Long[]{firstTableId});
        Assertions.assertThat((Collection)metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)secondTableHandle, (List)ImmutableList.of(), RetryMode.NO_RETRIES).activeTableIds()).contains((Object[])new Long[]{secondTableId});
    }

    @Test
    public void testReadTableBeforeCreationCompleted() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        TestMemoryMetadata.assertNoTables(metadata);
        SchemaTableName tableName = new SchemaTableName("default", "temp_table");
        MemoryOutputTableHandle table = metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(tableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty(), RetryMode.NO_RETRIES, false);
        List tableNames = metadata.listTables(TestingConnectorSession.SESSION, Optional.empty());
        ((AbstractIntegerAssert)Assertions.assertThat((int)tableNames.size()).describedAs("Expected exactly one table", new Object[0])).isEqualTo(1);
        metadata.finishCreateTable(TestingConnectorSession.SESSION, (ConnectorOutputTableHandle)table, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
    }

    @Test
    public void testCreateSchema() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        Assertions.assertThat((List)metadata.listSchemaNames(TestingConnectorSession.SESSION)).isEqualTo((Object)ImmutableList.of((Object)"default"));
        metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        Assertions.assertThat((List)metadata.listSchemaNames(TestingConnectorSession.SESSION)).isEqualTo((Object)ImmutableList.of((Object)"default", (Object)"test"));
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test"))).isEqualTo((Object)ImmutableList.of());
        SchemaTableName tableName = new SchemaTableName("test", "first_table");
        metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(tableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), SaveMode.FAIL);
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.empty())).isEqualTo((Object)ImmutableList.of((Object)tableName));
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test"))).isEqualTo((Object)ImmutableList.of((Object)tableName));
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of("default"))).isEqualTo((Object)ImmutableList.of());
    }

    @Test
    public void testCreateViewWithoutReplace() {
        SchemaTableName test = new SchemaTableName("test", "test_view");
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        try {
            metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("test"), (Map)ImmutableMap.of(), false);
        }
        catch (Exception e) {
            Fail.fail((String)"should have succeeded");
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("test"), (Map)ImmutableMap.of(), false)).isInstanceOf(TrinoException.class)).hasMessageMatching("View already exists: test\\.test_view");
    }

    @Test
    public void testCreateViewWithReplace() {
        SchemaTableName test = new SchemaTableName("test", "test_view");
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("aaa"), (Map)ImmutableMap.of(), true);
        metadata.createView(TestingConnectorSession.SESSION, test, TestMemoryMetadata.testingViewDefinition("bbb"), (Map)ImmutableMap.of(), true);
        Assertions.assertThat((Optional)metadata.getView(TestingConnectorSession.SESSION, test)).map(ConnectorViewDefinition::getOriginalSql).hasValue((Object)"bbb");
    }

    @Test
    public void testCreatedViewShouldBeListedAsTable() {
        String schemaName = "test";
        SchemaTableName viewName = new SchemaTableName(schemaName, "test_view");
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        metadata.createSchema(TestingConnectorSession.SESSION, schemaName, (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        metadata.createView(TestingConnectorSession.SESSION, viewName, TestMemoryMetadata.testingViewDefinition("aaa"), (Map)ImmutableMap.of(), true);
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of(schemaName))).contains((Object[])new SchemaTableName[]{viewName});
    }

    @Test
    public void testViews() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        SchemaTableName test1 = new SchemaTableName("test", "test_view1");
        SchemaTableName test2 = new SchemaTableName("test", "test_view2");
        SchemaTableName test3 = new SchemaTableName("test", "test_view3");
        metadata.createSchema(TestingConnectorSession.SESSION, "test", (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        metadata.createView(TestingConnectorSession.SESSION, test1, TestMemoryMetadata.testingViewDefinition("test1"), (Map)ImmutableMap.of(), false);
        metadata.createView(TestingConnectorSession.SESSION, test2, TestMemoryMetadata.testingViewDefinition("test2"), (Map)ImmutableMap.of(), false);
        List list = metadata.listViews(TestingConnectorSession.SESSION, Optional.of("test"));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)list, (Iterable)ImmutableList.of((Object)test1, (Object)test2));
        Map views = metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"));
        Assertions.assertThat(views.keySet()).isEqualTo((Object)ImmutableSet.of((Object)test1, (Object)test2));
        Assertions.assertThat((String)((ConnectorViewDefinition)views.get(test1)).getOriginalSql()).isEqualTo("test1");
        Assertions.assertThat((String)((ConnectorViewDefinition)views.get(test2)).getOriginalSql()).isEqualTo("test2");
        Assertions.assertThat((Map)metadata.getViews(TestingConnectorSession.SESSION, Optional.empty())).containsOnlyKeys((Object[])new SchemaTableName[]{test1, test2});
        Assertions.assertThat((Optional)metadata.getView(TestingConnectorSession.SESSION, new SchemaTableName("test", "test_view1"))).map(ConnectorViewDefinition::getOriginalSql).contains((Object)"test1");
        Assertions.assertThat((Optional)metadata.getView(TestingConnectorSession.SESSION, new SchemaTableName("test", "nonexistenttable"))).isEmpty();
        Assertions.assertThat((Map)metadata.getViews(TestingConnectorSession.SESSION, Optional.of("nonexistentschema"))).isEmpty();
        metadata.dropView(TestingConnectorSession.SESSION, test1);
        Assertions.assertThat((Map)metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"))).containsOnlyKeys((Object[])new SchemaTableName[]{test2});
        metadata.renameView(TestingConnectorSession.SESSION, test2, test3);
        Assertions.assertThat((Map)metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"))).containsOnlyKeys((Object[])new SchemaTableName[]{test3});
        metadata.dropView(TestingConnectorSession.SESSION, test3);
        Assertions.assertThat((Map)metadata.getViews(TestingConnectorSession.SESSION, Optional.of("test"))).isEmpty();
        Assertions.assertThat((Map)metadata.getViews(TestingConnectorSession.SESSION, Optional.empty())).isEmpty();
    }

    @Test
    public void testCreateTableAndViewInNotExistSchema() {
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        Assertions.assertThat((List)metadata.listSchemaNames(TestingConnectorSession.SESSION)).isEqualTo((Object)ImmutableList.of((Object)"default"));
        SchemaTableName table1 = new SchemaTableName("test1", "test_schema_table1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(table1, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty(), RetryMode.NO_RETRIES, false)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND}).hasMessage("Schema test1 not found");
        Assertions.assertThat((Object)metadata.getTableHandle(TestingConnectorSession.SESSION, table1, Optional.empty(), Optional.empty())).isNull();
        SchemaTableName view2 = new SchemaTableName("test2", "test_schema_view2");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> metadata.createView(TestingConnectorSession.SESSION, view2, TestMemoryMetadata.testingViewDefinition("aaa"), (Map)ImmutableMap.of(), false)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND}).hasMessage("Schema test2 not found");
        Assertions.assertThat((Object)metadata.getTableHandle(TestingConnectorSession.SESSION, view2, Optional.empty(), Optional.empty())).isNull();
        SchemaTableName view3 = new SchemaTableName("test3", "test_schema_view3");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> metadata.createView(TestingConnectorSession.SESSION, view3, TestMemoryMetadata.testingViewDefinition("bbb"), (Map)ImmutableMap.of(), true)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND}).hasMessage("Schema test3 not found");
        Assertions.assertThat((Object)metadata.getTableHandle(TestingConnectorSession.SESSION, view3, Optional.empty(), Optional.empty())).isNull();
        Assertions.assertThat((List)metadata.listSchemaNames(TestingConnectorSession.SESSION)).isEqualTo((Object)ImmutableList.of((Object)"default"));
    }

    @Test
    public void testRenameTable() {
        SchemaTableName tableName = new SchemaTableName("test_schema", "test_table_to_be_renamed");
        MemoryMetadata metadata = TestMemoryMetadata.createMetadata();
        metadata.createSchema(TestingConnectorSession.SESSION, "test_schema", (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        MemoryOutputTableHandle table = metadata.beginCreateTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(tableName, (List)ImmutableList.of(), (Map)ImmutableMap.of()), Optional.empty(), RetryMode.NO_RETRIES, false);
        metadata.finishCreateTable(TestingConnectorSession.SESSION, (ConnectorOutputTableHandle)table, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
        SchemaTableName invalidSchemaTableName = new SchemaTableName("test_schema_not_exist", "test_table_renamed");
        ConnectorTableHandle tableHandle = metadata.getTableHandle(TestingConnectorSession.SESSION, tableName, Optional.empty(), Optional.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> metadata.renameTable(TestingConnectorSession.SESSION, tableHandle, invalidSchemaTableName)).isInstanceOf(SchemaNotFoundException.class)).hasMessage("Schema test_schema_not_exist not found");
        SchemaTableName sameSchemaTableName = new SchemaTableName("test_schema", "test_renamed");
        metadata.renameTable(TestingConnectorSession.SESSION, metadata.getTableHandle(TestingConnectorSession.SESSION, tableName, Optional.empty(), Optional.empty()), sameSchemaTableName);
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test_schema"))).isEqualTo((Object)ImmutableList.of((Object)sameSchemaTableName));
        metadata.createSchema(TestingConnectorSession.SESSION, "test_different_schema", (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, TestingConnectorSession.SESSION.getUser()));
        SchemaTableName differentSchemaTableName = new SchemaTableName("test_different_schema", "test_renamed");
        metadata.renameTable(TestingConnectorSession.SESSION, metadata.getTableHandle(TestingConnectorSession.SESSION, sameSchemaTableName, Optional.empty(), Optional.empty()), differentSchemaTableName);
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test_schema"))).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.of("test_different_schema"))).isEqualTo((Object)ImmutableList.of((Object)differentSchemaTableName));
    }

    private static void assertNoTables(MemoryMetadata metadata) {
        ((ListAssert)Assertions.assertThat((List)metadata.listTables(TestingConnectorSession.SESSION, Optional.empty())).describedAs("No table was expected", new Object[0])).isEqualTo((Object)ImmutableList.of());
    }

    private static ConnectorViewDefinition testingViewDefinition(String sql) {
        return new ConnectorViewDefinition(sql, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of());
    }

    private static MemoryMetadata createMetadata() {
        return new MemoryMetadata((NodeManager)new TestingNodeManager());
    }
}

