/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.base.Verify;
import io.trino.Session;
import io.trino.plugin.memory.MemoryQueryRunner;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMemoryTableStatistics
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return MemoryQueryRunner.builder().setInitialTables(List.of(TpchTable.NATION)).build();
    }

    @Test
    public void testBasic() {
        this.assertQuery("SHOW STATS FOR nation", "VALUES ('nationkey', null, null, null, null, null, null),('name', null, null, null, null, null, null),('regionkey', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 25, null, null)");
    }

    @Test
    public void testEmptyTable() {
        this.computeActual("CREATE TABLE empty_table AS TABLE nation WITH NO DATA");
        this.assertQuery("SHOW STATS FOR empty_table", "VALUES ('nationkey', 0, 0, 1, null, null, null),('name', 0, 0, 1, null, null, null),('regionkey', 0, 0, 1, null, null, null),('comment', 0, 0, 1, null, null, null),(null, null, null, null, 0, null, null)");
    }

    @Test
    public void testView() {
        this.computeActual("CREATE VIEW nation_view AS TABLE nation");
        this.assertQuery("SHOW STATS FOR nation_view", "VALUES ('nationkey', null, null, null, null, null, null),('name', null, null, null, null, null, null),('regionkey', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 25.0, null, null)");
    }

    @Test
    public void testStatsWithLimitPushdown() {
        String query = "SELECT * FROM nation LIMIT 3";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).skipResultsCorrectnessCheckForPushdown().isFullyPushedDown();
        this.assertQuery(this.disableStatisticsPrecalculation(this.getSession()), "SHOW STATS FOR (" + query + ")", "VALUES ('nationkey', null, null, null, null, null, null),('name', null, null, null, null, null, null),('regionkey', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 25, null, null)");
        this.assertQuery("SHOW STATS FOR (" + query + ")", "VALUES ('nationkey', null, null, null, null, null, null),('name', null, null, null, null, null, null),('regionkey', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 3, null, null)");
    }

    @Test
    public void testStatsWithSamplePushdown() {
        String query = "SELECT * FROM nation TABLESAMPLE SYSTEM (50)";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).skipResultsCorrectnessCheckForPushdown().isFullyPushedDown();
        this.assertQuery(this.disableStatisticsPrecalculation(this.getSession()), "SHOW STATS FOR (" + query + ")", "VALUES ('nationkey', null, null, null, null, null, null),('name', null, null, null, null, null, null),('regionkey', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 25, null, null)");
        this.assertQuery("SHOW STATS FOR (" + query + ")", "VALUES ('nationkey', null, null, null, null, null, null),('name', null, null, null, null, null, null),('regionkey', null, null, null, null, null, null),('comment', null, null, null, null, null, null),(null, null, null, null, 12.5, null, null)");
    }

    private Session disableStatisticsPrecalculation(Session base) {
        Verify.verify((boolean)new OptimizerConfig().isStatisticsPrecalculationForPushdownEnabled(), (String)"this assumes precalculation is enabled by default", (Object[])new Object[0]);
        return Session.builder((Session)base).setSystemProperty("statistics_precalculation_for_pushdown_enabled", "false").build();
    }
}

