/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import java.util.OptionalLong;

@Immutable
public class BooleanStatistics {
    private final OptionalLong trueCount;
    private final OptionalLong falseCount;

    @JsonCreator
    public BooleanStatistics(@JsonProperty(value="trueCount") OptionalLong trueCount, @JsonProperty(value="falseCount") OptionalLong falseCount) {
        this.trueCount = Objects.requireNonNull(trueCount, "trueCount is null");
        this.falseCount = Objects.requireNonNull(falseCount, "falseCount is null");
    }

    @JsonProperty
    public OptionalLong getTrueCount() {
        return this.trueCount;
    }

    @JsonProperty
    public OptionalLong getFalseCount() {
        return this.falseCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanStatistics that = (BooleanStatistics)o;
        return Objects.equals(this.trueCount, that.trueCount) && Objects.equals(this.falseCount, that.falseCount);
    }

    public int hashCode() {
        return Objects.hash(this.trueCount, this.falseCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("trueCount", (Object)this.trueCount).add("falseCount", (Object)this.falseCount).toString();
    }
}

