/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.metastore.HiveTypeName;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.TypeInfo;
import io.trino.metastore.type.TypeInfoFactory;
import io.trino.metastore.type.TypeInfoUtils;
import java.util.List;
import java.util.Objects;

public final class HiveType {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(HiveType.class);
    public static final HiveType HIVE_BOOLEAN = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("boolean"));
    public static final HiveType HIVE_BYTE = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("tinyint"));
    public static final HiveType HIVE_SHORT = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("smallint"));
    public static final HiveType HIVE_INT = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("int"));
    public static final HiveType HIVE_LONG = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("bigint"));
    public static final HiveType HIVE_FLOAT = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("float"));
    public static final HiveType HIVE_DOUBLE = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("double"));
    public static final HiveType HIVE_STRING = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("string"));
    public static final HiveType HIVE_TIMESTAMP = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("timestamp"));
    public static final HiveType HIVE_TIMESTAMPLOCALTZ = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("timestamp with local time zone"));
    public static final HiveType HIVE_DATE = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("date"));
    public static final HiveType HIVE_BINARY = new HiveType(TypeInfoFactory.getPrimitiveTypeInfo("binary"));
    private final HiveTypeName hiveTypeName;
    private final TypeInfo typeInfo;

    private HiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        this.hiveTypeName = new HiveTypeName(typeInfo.getTypeName());
        this.typeInfo = typeInfo;
    }

    public HiveTypeName getHiveTypeName() {
        return this.hiveTypeName;
    }

    public Category getCategory() {
        return this.typeInfo.getCategory();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    @JsonValue
    public String toString() {
        return this.hiveTypeName.toString();
    }

    @JsonCreator
    public static HiveType valueOf(String hiveTypeName) {
        Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
        return HiveType.fromTypeInfo(TypeInfoUtils.getTypeInfoFromTypeString(hiveTypeName));
    }

    public static List<HiveType> toHiveTypes(String hiveTypes) {
        Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        return (List)TypeInfoUtils.getTypeInfosFromTypeString(hiveTypes).stream().map(HiveType::fromTypeInfo).collect(ImmutableList.toImmutableList());
    }

    public static HiveType fromTypeInfo(TypeInfo typeInfo) {
        return new HiveType(typeInfo);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.hiveTypeName.getEstimatedSizeInBytes() + this.typeInfo.getRetainedSizeInBytes();
    }
}

