/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import io.trino.metastore.MetastoreErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SortOrder;
import java.util.Objects;

public record SortingColumn(String columnName, Order order) {
    public SortingColumn {
        Objects.requireNonNull(columnName, "columnName is null");
        Objects.requireNonNull(order, "order is null");
    }

    public static enum Order {
        ASCENDING(SortOrder.ASC_NULLS_FIRST, 1),
        DESCENDING(SortOrder.DESC_NULLS_LAST, 0);

        private final SortOrder sortOrder;
        private final int hiveOrder;

        private Order(SortOrder sortOrder, int hiveOrder) {
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
            this.hiveOrder = hiveOrder;
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public int getHiveOrder() {
            return this.hiveOrder;
        }

        public static Order fromMetastoreApiOrder(int value, String tablePartitionName) {
            for (Order order : Order.values()) {
                if (value != order.getHiveOrder()) continue;
                return order;
            }
            throw new TrinoException((ErrorCodeSupplier)MetastoreErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has invalid sorting order: " + tablePartitionName);
        }
    }
}

