/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.trino.metastore.MetastoreErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Objects;

@Immutable
public class StorageFormat {
    public static final StorageFormat NULL_STORAGE_FORMAT;
    public static final StorageFormat VIEW_STORAGE_FORMAT;
    private final String serde;
    private final String inputFormat;
    private final String outputFormat;

    private StorageFormat(String serde, String inputFormat, String outputFormat) {
        this.serde = serde;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
    }

    public String getSerde() {
        if (this.serde == null) {
            throw new TrinoException((ErrorCodeSupplier)MetastoreErrorCode.HIVE_INVALID_METADATA, "SerDe is not present in StorageFormat");
        }
        return this.serde;
    }

    public String getInputFormat() {
        if (this.inputFormat == null) {
            throw new TrinoException((ErrorCodeSupplier)MetastoreErrorCode.HIVE_UNSUPPORTED_FORMAT, "InputFormat is not present in StorageFormat");
        }
        return this.inputFormat;
    }

    public String getOutputFormat() {
        if (this.outputFormat == null) {
            throw new TrinoException((ErrorCodeSupplier)MetastoreErrorCode.HIVE_UNSUPPORTED_FORMAT, "OutputFormat is not present in StorageFormat");
        }
        return this.outputFormat;
    }

    @JsonProperty(value="serde")
    public String getSerDeNullable() {
        return this.serde;
    }

    @JsonProperty(value="inputFormat")
    public String getInputFormatNullable() {
        return this.inputFormat;
    }

    @JsonProperty(value="outputFormat")
    public String getOutputFormatNullable() {
        return this.outputFormat;
    }

    public static StorageFormat create(String serde, String inputFormat, String outputFormat) {
        return new StorageFormat(Objects.requireNonNull(serde, "serde is null"), Objects.requireNonNull(inputFormat, "inputFormat is null"), Objects.requireNonNull(outputFormat, "outputFormat is null"));
    }

    @JsonCreator
    public static StorageFormat createNullable(@JsonProperty(value="serde") String serde, @JsonProperty(value="inputFormat") String inputFormat, @JsonProperty(value="outputFormat") String outputFormat) {
        if (serde == null && inputFormat == null && outputFormat == null) {
            return NULL_STORAGE_FORMAT;
        }
        return new StorageFormat(serde, inputFormat, outputFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageFormat that = (StorageFormat)o;
        return Objects.equals(this.serde, that.serde) && Objects.equals(this.inputFormat, that.inputFormat) && Objects.equals(this.outputFormat, that.outputFormat);
    }

    public int hashCode() {
        return Objects.hash(this.serde, this.inputFormat, this.outputFormat);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serde", (Object)this.serde).add("inputFormat", (Object)this.inputFormat).add("outputFormat", (Object)this.outputFormat).toString();
    }

    static {
        VIEW_STORAGE_FORMAT = NULL_STORAGE_FORMAT = new StorageFormat(null, null, null);
    }
}

