/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.TrinoPrincipal;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class HivePrincipal {
    private final PrincipalType type;
    private final String name;

    public static HivePrincipal from(ConnectorIdentity identity) {
        if (identity.getConnectorRole().isEmpty()) {
            return HivePrincipal.ofUser(identity.getUser());
        }
        SelectedRole.Type type = ((SelectedRole)identity.getConnectorRole().get()).getType();
        if (type == SelectedRole.Type.ALL) {
            return HivePrincipal.ofUser(identity.getUser());
        }
        Preconditions.checkArgument((type == SelectedRole.Type.ROLE ? 1 : 0) != 0, (String)"Expected role type to be ALL or ROLE, but got: %s", (Object)type);
        return HivePrincipal.ofRole((String)((SelectedRole)identity.getConnectorRole().get()).getRole().get());
    }

    private static HivePrincipal ofUser(String user) {
        return new HivePrincipal(PrincipalType.USER, user);
    }

    private static HivePrincipal ofRole(String role) {
        return new HivePrincipal(PrincipalType.ROLE, role);
    }

    public static Set<HivePrincipal> from(Set<TrinoPrincipal> trinoPrincipals) {
        return (Set)trinoPrincipals.stream().map(HivePrincipal::from).collect(ImmutableSet.toImmutableSet());
    }

    public static HivePrincipal from(TrinoPrincipal trinoPrincipal) {
        return new HivePrincipal(trinoPrincipal.getType(), trinoPrincipal.getName());
    }

    @JsonCreator
    public HivePrincipal(@JsonProperty(value="type") PrincipalType type, @JsonProperty(value="name") String name) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = HivePrincipal.canonicalName(type, name);
    }

    private static String canonicalName(PrincipalType type, String name) {
        Objects.requireNonNull(name, "name is null");
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PrincipalType.USER -> name;
            case PrincipalType.ROLE -> name.toLowerCase(Locale.ENGLISH);
        };
    }

    @JsonProperty
    public PrincipalType getType() {
        return this.type;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrincipal hivePrincipal = (HivePrincipal)o;
        return this.type == hivePrincipal.type && Objects.equals(this.name, hivePrincipal.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        return String.valueOf(this.type) + " " + this.name;
    }

    public TrinoPrincipal toTrinoPrincipal() {
        return new TrinoPrincipal(this.type, this.name);
    }
}

