/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.tracing;

import com.google.common.collect.ImmutableSet;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.metastore.AcidOperation;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.Database;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.metastore.tracing.MetastoreAttributes;
import io.trino.metastore.tracing.Tracing;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class TracingHiveMetastore
implements HiveMetastore {
    private final Tracer tracer;
    private final HiveMetastore delegate;

    public TracingHiveMetastore(Tracer tracer, HiveMetastore delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getDatabase").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.getDatabase(databaseName));
    }

    @Override
    public List<String> getAllDatabases() {
        Span span = this.tracer.spanBuilder("HiveMetastore.getAllDatabases").startSpan();
        return Tracing.withTracing(span, () -> {
            List<String> databases = this.delegate.getAllDatabases();
            span.setAttribute(MetastoreAttributes.SCHEMA_RESPONSE_COUNT, databases.size());
            return databases;
        });
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.getTable(databaseName, tableName));
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getTableColumnStatistics").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.getTableColumnStatistics(databaseName, tableName, columnNames));
    }

    @Override
    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getPartitionColumnStatistics").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.PARTITION_REQUEST_COUNT, (Object)partitionNames.size()).startSpan();
        return Tracing.withTracing(span, () -> {
            Map<String, Map<String, HiveColumnStatistics>> partitionColumnStatistics = this.delegate.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames);
            span.setAttribute(MetastoreAttributes.PARTITION_RESPONSE_COUNT, partitionColumnStatistics.size());
            return partitionColumnStatistics;
        });
    }

    @Override
    public boolean useSparkTableStatistics() {
        return this.delegate.useSparkTableStatistics();
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, OptionalLong acidWriteId, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        Span span = this.tracer.spanBuilder("HiveMetastore.updateTableStatistics").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        acidWriteId.ifPresent(id -> span.setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)id));
        Tracing.withTracing(span, () -> this.delegate.updateTableStatistics(databaseName, tableName, acidWriteId, mode, statisticsUpdate));
    }

    @Override
    public void updatePartitionStatistics(Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        Span span = this.tracer.spanBuilder("HiveMetastore.updatePartitionStatistics").setAttribute(MetastoreAttributes.SCHEMA, (Object)table.getDatabaseName()).setAttribute(MetastoreAttributes.TABLE, (Object)table.getTableName()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.updatePartitionStatistics(table, mode, partitionUpdates));
    }

    @Override
    public List<TableInfo> getTables(String databaseName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getTables").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).startSpan();
        return Tracing.withTracing(span, () -> {
            List<TableInfo> tables = this.delegate.getTables(databaseName);
            span.setAttribute(MetastoreAttributes.TABLE_RESPONSE_COUNT, tables.size());
            return tables;
        });
    }

    @Override
    public List<String> getTableNamesWithParameters(String databaseName, String parameterKey, ImmutableSet<String> parameterValues) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getTableNamesWithParameters").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)parameterKey).startSpan();
        return Tracing.withTracing(span, () -> {
            List<String> tables = this.delegate.getTableNamesWithParameters(databaseName, parameterKey, parameterValues);
            span.setAttribute(MetastoreAttributes.TABLE_RESPONSE_COUNT, tables.size());
            return tables;
        });
    }

    @Override
    public void createDatabase(Database database) {
        Span span = this.tracer.spanBuilder("HiveMetastore.createDatabase").setAttribute(MetastoreAttributes.SCHEMA, (Object)database.getDatabaseName()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.createDatabase(database));
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        Span span = this.tracer.spanBuilder("HiveMetastore.dropDatabase").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.dropDatabase(databaseName, deleteData));
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.renameDatabase").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.renameDatabase(databaseName, newDatabaseName));
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        Span span = this.tracer.spanBuilder("HiveMetastore.setDatabaseOwner").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.setDatabaseOwner(databaseName, principal));
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        Span span = this.tracer.spanBuilder("HiveMetastore.createTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)table.getDatabaseName()).setAttribute(MetastoreAttributes.TABLE, (Object)table.getTableName()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.createTable(table, principalPrivileges));
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        Span span = this.tracer.spanBuilder("HiveMetastore.dropTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.dropTable(databaseName, tableName, deleteData));
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        Span span = this.tracer.spanBuilder("HiveMetastore.replaceTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges));
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.renameTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName));
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        Span span = this.tracer.spanBuilder("HiveMetastore.commentTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.commentTable(databaseName, tableName, comment));
    }

    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        Span span = this.tracer.spanBuilder("HiveMetastore.setTableOwner").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.setTableOwner(databaseName, tableName, principal));
    }

    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        Span span = this.tracer.spanBuilder("HiveMetastore.commentColumn").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.commentColumn(databaseName, tableName, columnName, comment));
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Span span = this.tracer.spanBuilder("HiveMetastore.addColumn").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment));
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.renameColumn").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName));
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.dropColumn").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.dropColumn(databaseName, tableName, columnName));
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getPartition").setAttribute(MetastoreAttributes.SCHEMA, (Object)table.getDatabaseName()).setAttribute(MetastoreAttributes.TABLE, (Object)table.getTableName()).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.getPartition(table, partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getPartitionNamesByFilter").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        return Tracing.withTracing(span, () -> {
            Optional<List<String>> partitionNames = this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter);
            partitionNames.ifPresent(partitions -> span.setAttribute(MetastoreAttributes.PARTITION_RESPONSE_COUNT, partitions.size()));
            return partitionNames;
        });
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getPartitionsByNames").setAttribute(MetastoreAttributes.SCHEMA, (Object)table.getDatabaseName()).setAttribute(MetastoreAttributes.TABLE, (Object)table.getTableName()).setAttribute(MetastoreAttributes.PARTITION_REQUEST_COUNT, (Object)partitionNames.size()).startSpan();
        return Tracing.withTracing(span, () -> {
            Map<String, Optional<Partition>> partitions = this.delegate.getPartitionsByNames(table, partitionNames);
            span.setAttribute(MetastoreAttributes.PARTITION_RESPONSE_COUNT, partitions.size());
            return partitions;
        });
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        Span span = this.tracer.spanBuilder("HiveMetastore.addPartitions").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.PARTITION_REQUEST_COUNT, (Object)partitions.size()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.addPartitions(databaseName, tableName, partitions));
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        Span span = this.tracer.spanBuilder("HiveMetastore.dropPartition").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.dropPartition(databaseName, tableName, parts, deleteData));
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        Span span = this.tracer.spanBuilder("HiveMetastore.alterPartition").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.PARTITION, (Object)partition.getPartitionName()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.alterPartition(databaseName, tableName, partition));
    }

    @Override
    public void createRole(String role, String grantor) {
        Span span = this.tracer.spanBuilder("HiveMetastore.createRole").startSpan();
        Tracing.withTracing(span, () -> this.delegate.createRole(role, grantor));
    }

    @Override
    public void dropRole(String role) {
        Span span = this.tracer.spanBuilder("HiveMetastore.dropRole").startSpan();
        Tracing.withTracing(span, () -> this.delegate.dropRole(role));
    }

    @Override
    public Set<String> listRoles() {
        Span span = this.tracer.spanBuilder("HiveMetastore.listRoles").startSpan();
        return Tracing.withTracing(span, this.delegate::listRoles);
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        Span span = this.tracer.spanBuilder("HiveMetastore.grantRoles").startSpan();
        Tracing.withTracing(span, () -> this.delegate.grantRoles(roles, grantees, adminOption, grantor));
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        Span span = this.tracer.spanBuilder("HiveMetastore.revokeRoles").startSpan();
        Tracing.withTracing(span, () -> this.delegate.revokeRoles(roles, grantees, adminOption, grantor));
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        Span span = this.tracer.spanBuilder("HiveMetastore.listRoleGrants").startSpan();
        return Tracing.withTracing(span, () -> this.delegate.listRoleGrants(principal));
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        Span span = this.tracer.spanBuilder("HiveMetastore.grantTablePrivileges").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption));
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        Span span = this.tracer.spanBuilder("HiveMetastore.revokeTablePrivileges").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption));
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        Span span = this.tracer.spanBuilder("HiveMetastore.listTablePrivileges").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal));
    }

    @Override
    public void checkSupportsTransactions() {
        this.delegate.checkSupportsTransactions();
    }

    @Override
    public long openTransaction(AcidTransactionOwner transactionOwner) {
        Span span = this.tracer.spanBuilder("HiveMetastore.openTransaction").startSpan();
        return Tracing.withTracing(span, () -> {
            long transactionId = this.delegate.openTransaction(transactionOwner);
            span.setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId);
            return transactionId;
        });
    }

    @Override
    public void commitTransaction(long transactionId) {
        Span span = this.tracer.spanBuilder("HiveMetastore.commitTransaction").setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.commitTransaction(transactionId));
    }

    @Override
    public void abortTransaction(long transactionId) {
        Span span = this.tracer.spanBuilder("HiveMetastore.abortTransaction").setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.abortTransaction(transactionId));
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) {
        Span span = this.tracer.spanBuilder("HiveMetastore.sendTransactionHeartbeat").setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.sendTransactionHeartbeat(transactionId));
    }

    @Override
    public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        Span span = this.tracer.spanBuilder("HiveMetastore.acquireSharedReadLock").setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.acquireSharedReadLock(transactionOwner, queryId, transactionId, fullTables, partitions));
    }

    @Override
    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getValidWriteIds").setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)currentTransactionId).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.getValidWriteIds(tables, currentTransactionId));
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getConfigValue").startSpan();
        return Tracing.withTracing(span, () -> this.delegate.getConfigValue(name));
    }

    @Override
    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        Span span = this.tracer.spanBuilder("HiveMetastore.allocateWriteId").setAttribute(MetastoreAttributes.SCHEMA, (Object)dbName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.allocateWriteId(dbName, tableName, transactionId));
    }

    @Override
    public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, AcidOperation operation, boolean isDynamicPartitionWrite) {
        Span span = this.tracer.spanBuilder("HiveMetastore.acquireTableWriteLock").setAttribute(MetastoreAttributes.SCHEMA, (Object)dbName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, operation, isDynamicPartitionWrite));
    }

    @Override
    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        Span span = this.tracer.spanBuilder("HiveMetastore.updateTableWriteId").setAttribute(MetastoreAttributes.SCHEMA, (Object)dbName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange));
    }

    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        Span span = this.tracer.spanBuilder("HiveMetastore.addDynamicPartitions").setAttribute(MetastoreAttributes.SCHEMA, (Object)dbName).setAttribute(MetastoreAttributes.TABLE, (Object)tableName).setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).setAttribute(MetastoreAttributes.PARTITION_REQUEST_COUNT, (Object)partitionNames.size()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation));
    }

    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        Span span = this.tracer.spanBuilder("HiveMetastore.alterTransactionalTable").setAttribute(MetastoreAttributes.SCHEMA, (Object)table.getDatabaseName()).setAttribute(MetastoreAttributes.TABLE, (Object)table.getTableName()).setAttribute(MetastoreAttributes.ACID_TRANSACTION, (Object)transactionId).startSpan();
        Tracing.withTracing(span, () -> this.delegate.alterTransactionalTable(table, transactionId, writeId, principalPrivileges));
    }

    @Override
    public boolean functionExists(String databaseName, String functionName, String signatureToken) {
        Span span = this.tracer.spanBuilder("HiveMetastore.functionExists").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.FUNCTION, (Object)functionName).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.functionExists(databaseName, functionName, signatureToken));
    }

    @Override
    public Collection<LanguageFunction> getAllFunctions(String databaseName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getAllFunctions").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).startSpan();
        return Tracing.withTracing(span, () -> {
            Collection<LanguageFunction> functions = this.delegate.getAllFunctions(databaseName);
            span.setAttribute(MetastoreAttributes.FUNCTION_RESPONSE_COUNT, functions.size());
            return functions;
        });
    }

    @Override
    public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
        Span span = this.tracer.spanBuilder("HiveMetastore.getFunctions").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.FUNCTION, (Object)functionName).startSpan();
        return Tracing.withTracing(span, () -> {
            Collection<LanguageFunction> functions = this.delegate.getFunctions(databaseName, functionName);
            span.setAttribute(MetastoreAttributes.FUNCTION_RESPONSE_COUNT, functions.size());
            return functions;
        });
    }

    @Override
    public void createFunction(String databaseName, String functionName, LanguageFunction function) {
        Span span = this.tracer.spanBuilder("HiveMetastore.createFunction").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.FUNCTION, (Object)functionName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.createFunction(databaseName, functionName, function));
    }

    @Override
    public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
        Span span = this.tracer.spanBuilder("HiveMetastore.replaceFunction").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.FUNCTION, (Object)functionName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.replaceFunction(databaseName, functionName, function));
    }

    @Override
    public void dropFunction(String databaseName, String functionName, String signatureToken) {
        Span span = this.tracer.spanBuilder("HiveMetastore.dropFunction").setAttribute(MetastoreAttributes.SCHEMA, (Object)databaseName).setAttribute(MetastoreAttributes.FUNCTION, (Object)functionName).startSpan();
        Tracing.withTracing(span, () -> this.delegate.dropFunction(databaseName, functionName, signatureToken));
    }
}

