/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.type;

import io.trino.metastore.type.PrimitiveCategory;
import io.trino.metastore.type.TypeInfo;
import io.trino.metastore.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeInfoUtils {
    private static final Map<String, PrimitiveTypeEntry> TYPES = new HashMap<String, PrimitiveTypeEntry>();

    private TypeInfoUtils() {
    }

    private static void registerType(PrimitiveTypeEntry entry) {
        TYPES.put(entry.typeName(), entry);
    }

    public static PrimitiveTypeEntry getTypeEntryFromTypeName(String typeName) {
        return TYPES.get(typeName);
    }

    public static String getBaseName(String typeName) {
        int index = typeName.indexOf(40);
        if (index == -1) {
            return typeName;
        }
        return typeName.substring(0, index);
    }

    public static PrimitiveParts parsePrimitiveParts(String typeInfoString) {
        return new TypeInfoParser(typeInfoString).parsePrimitiveParts();
    }

    public static List<TypeInfo> getTypeInfosFromTypeString(String typeString) {
        return new TypeInfoParser(typeString).parseTypeInfos();
    }

    public static TypeInfo getTypeInfoFromTypeString(String typeString) {
        return TypeInfoUtils.getTypeInfosFromTypeString(typeString).get(0);
    }

    static {
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.BINARY, "binary"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.STRING, "string"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.CHAR, "char"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.VARCHAR, "varchar"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.BOOLEAN, "boolean"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.INT, "int"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.LONG, "bigint"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.FLOAT, "float"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.VOID, "void"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.DOUBLE, "double"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.BYTE, "tinyint"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.SHORT, "smallint"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.DATE, "date"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.TIMESTAMP, "timestamp"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.TIMESTAMPLOCALTZ, "timestamp with local time zone"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.INTERVAL_YEAR_MONTH, "interval_year_month"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.INTERVAL_DAY_TIME, "interval_day_time"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.DECIMAL, "decimal"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.VARIANT, "variant"));
        TypeInfoUtils.registerType(new PrimitiveTypeEntry(PrimitiveCategory.UNKNOWN, "unknown"));
    }

    public record PrimitiveTypeEntry(PrimitiveCategory primitiveCategory, String typeName) {
        public PrimitiveTypeEntry {
            Objects.requireNonNull(primitiveCategory, "primitiveCategory is null");
            Objects.requireNonNull(typeName, "typeName is null");
        }
    }

    private static class TypeInfoParser {
        private final String typeInfoString;
        private final List<Token> typeInfoTokens;
        private int index;

        private static boolean isTypeChar(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == ' ' || c == '$';
        }

        private static List<Token> tokenize(String typeInfoString) {
            ArrayList<Token> tokens = new ArrayList<Token>();
            int begin = 0;
            for (int end = 1; end <= typeInfoString.length(); ++end) {
                if (begin > 0 && typeInfoString.charAt(begin - 1) == '(' && typeInfoString.charAt(begin) == '\'') {
                    ++begin;
                    while (typeInfoString.charAt(++end) != '\'') {
                    }
                } else if (typeInfoString.charAt(begin) == '\'' && typeInfoString.charAt(begin + 1) == ')') {
                    ++begin;
                    ++end;
                }
                if (end != typeInfoString.length() && TypeInfoParser.isTypeChar(typeInfoString.charAt(end - 1)) && TypeInfoParser.isTypeChar(typeInfoString.charAt(end))) continue;
                Token token = new Token(begin, typeInfoString.substring(begin, end), TypeInfoParser.isTypeChar(typeInfoString.charAt(begin)));
                tokens.add(token);
                begin = end;
            }
            return tokens;
        }

        public TypeInfoParser(String typeInfoString) {
            this.typeInfoString = typeInfoString;
            this.typeInfoTokens = TypeInfoParser.tokenize(typeInfoString);
        }

        public List<TypeInfo> parseTypeInfos() {
            ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
            this.index = 0;
            block8: while (this.index < this.typeInfoTokens.size()) {
                typeInfos.add(this.parseType());
                if (this.index >= this.typeInfoTokens.size()) continue;
                Token separator = this.typeInfoTokens.get(this.index);
                switch (separator.text()) {
                    case ",": 
                    case ";": 
                    case ":": {
                        ++this.index;
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Error: ',', ':', or ';' expected at position %s from '%s' %s".formatted(separator.position(), this.typeInfoString, this.typeInfoTokens));
            }
            return typeInfos;
        }

        private Token peek() {
            if (this.index < this.typeInfoTokens.size()) {
                return this.typeInfoTokens.get(this.index);
            }
            return null;
        }

        private Token expect(String item) {
            return this.expect(item, null);
        }

        private Token expect(String item, String alternative) {
            if (this.index >= this.typeInfoTokens.size()) {
                throw new IllegalArgumentException("Error: %s expected at the end of '%s'".formatted(item, this.typeInfoString));
            }
            Token token = this.typeInfoTokens.get(this.index);
            if (item.equals("type") ? !"array".equals(token.text()) && !"map".equals(token.text()) && !"struct".equals(token.text()) && !"uniontype".equals(token.text()) && TypeInfoUtils.getTypeEntryFromTypeName(token.text()) == null && !token.text().equals(alternative) : (item.equals("name") ? !token.type() && !token.text().equals(alternative) : !item.equals(token.text()) && !token.text().equals(alternative))) {
                throw new IllegalArgumentException("Error: %s expected at the position %s of '%s' but '%s' is found.".formatted(item, token.position(), this.typeInfoString, token.text()));
            }
            ++this.index;
            return token;
        }

        private String[] parseParams() {
            LinkedList<String> params = new LinkedList<String>();
            Token token = this.peek();
            if (token != null && token.text().equals("(")) {
                this.expect("(");
                token = this.peek();
                while (token == null || !token.text().equals(")")) {
                    token = this.expect("name");
                    params.add(token.text());
                    token = this.expect(",", ")");
                }
                if (params.isEmpty()) {
                    throw new IllegalArgumentException("type parameters expected for type string " + this.typeInfoString);
                }
            }
            return params.toArray(new String[0]);
        }

        private TypeInfo parseType() {
            Token token = this.expect("type");
            PrimitiveTypeEntry typeEntry = TypeInfoUtils.getTypeEntryFromTypeName(token.text());
            if (typeEntry != null && typeEntry.primitiveCategory() != PrimitiveCategory.UNKNOWN) {
                String[] params = this.parseParams();
                switch (typeEntry.primitiveCategory()) {
                    case CHAR: 
                    case VARCHAR: {
                        if (params.length == 0) {
                            throw new IllegalArgumentException("%s type is specified without length: %s".formatted(typeEntry.typeName(), this.typeInfoString));
                        }
                        if (params.length == 1) {
                            int length = Integer.parseInt(params[0]);
                            return typeEntry.primitiveCategory() == PrimitiveCategory.VARCHAR ? TypeInfoFactory.getVarcharTypeInfo(length) : TypeInfoFactory.getCharTypeInfo(length);
                        }
                        throw new IllegalArgumentException("Type %s only takes one parameter, but %s is seen".formatted(typeEntry.typeName(), params.length));
                    }
                    case DECIMAL: {
                        if (params.length == 0) {
                            return TypeInfoFactory.getDecimalTypeInfo(10, 0);
                        }
                        if (params.length == 1) {
                            return TypeInfoFactory.getDecimalTypeInfo(Integer.parseInt(params[0]), 0);
                        }
                        if (params.length == 2) {
                            return TypeInfoFactory.getDecimalTypeInfo(Integer.parseInt(params[0]), Integer.parseInt(params[1]));
                        }
                        throw new IllegalArgumentException("Type decimal only takes two parameter, but %s is seen".formatted(params.length));
                    }
                }
                return TypeInfoFactory.getPrimitiveTypeInfo(typeEntry.typeName());
            }
            if ("array".equals(token.text())) {
                this.expect("<");
                TypeInfo listElementType = this.parseType();
                this.expect(">");
                return TypeInfoFactory.getListTypeInfo(listElementType);
            }
            if ("map".equals(token.text())) {
                this.expect("<");
                TypeInfo mapKeyType = this.parseType();
                this.expect(",");
                TypeInfo mapValueType = this.parseType();
                this.expect(">");
                return TypeInfoFactory.getMapTypeInfo(mapKeyType, mapValueType);
            }
            if ("struct".equals(token.text())) {
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<TypeInfo> fieldTypeInfos = new ArrayList<TypeInfo>();
                boolean first = true;
                while (true) {
                    if (first) {
                        this.expect("<");
                        first = false;
                    } else {
                        Token separator = this.expect(">", ",");
                        if (separator.text().equals(">")) break;
                    }
                    Token name = this.expect("name", ">");
                    if (name.text().equals(">")) break;
                    fieldNames.add(name.text());
                    this.expect(":");
                    fieldTypeInfos.add(this.parseType());
                }
                return TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypeInfos);
            }
            if ("uniontype".equals(token.text())) {
                ArrayList<TypeInfo> objectTypeInfos = new ArrayList<TypeInfo>();
                boolean first = true;
                while (true) {
                    if (first) {
                        this.expect("<");
                        first = false;
                    } else {
                        Token separator = this.expect(">", ",");
                        if (separator.text().equals(">")) break;
                    }
                    objectTypeInfos.add(this.parseType());
                }
                return TypeInfoFactory.getUnionTypeInfo(objectTypeInfos);
            }
            throw new RuntimeException("Internal error parsing position %s of '%s'".formatted(token.position(), this.typeInfoString));
        }

        public PrimitiveParts parsePrimitiveParts() {
            Token token = this.expect("type");
            return new PrimitiveParts(token.text(), this.parseParams());
        }

        public record Token(int position, String text, boolean type) {
            public Token {
                Objects.requireNonNull(text, "text is null");
            }

            @Override
            public String toString() {
                return "%s:%s".formatted(this.position, this.text);
            }
        }
    }

    public record PrimitiveParts(String typeName, String[] typeParams) {
        public PrimitiveParts {
            Objects.requireNonNull(typeName, "typeName is null");
            Objects.requireNonNull(typeParams, "typeParams is null");
        }
    }
}

