/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public record TableInfo(SchemaTableName tableName, ExtendedRelationType extendedRelationType) {
    public static final String PRESTO_VIEW_COMMENT = "Presto View";
    public static final String ICEBERG_MATERIALIZED_VIEW_COMMENT = "Presto Materialized View";

    public TableInfo {
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(extendedRelationType, "extendedRelationType is null");
    }

    public static enum ExtendedRelationType {
        TABLE(RelationType.TABLE),
        OTHER_VIEW(RelationType.VIEW),
        OTHER_MATERIALIZED_VIEW(RelationType.MATERIALIZED_VIEW),
        TRINO_VIEW(RelationType.VIEW),
        TRINO_MATERIALIZED_VIEW(RelationType.MATERIALIZED_VIEW);

        private final RelationType relationType;

        private ExtendedRelationType(RelationType relationType) {
            this.relationType = relationType;
        }

        public RelationType toRelationType() {
            return this.relationType;
        }

        public static ExtendedRelationType fromTableTypeAndComment(String tableType, String comment) {
            return switch (tableType) {
                case "VIRTUAL_VIEW" -> {
                    if (TableInfo.PRESTO_VIEW_COMMENT.equals(comment)) {
                        yield TRINO_VIEW;
                    }
                    if (TableInfo.ICEBERG_MATERIALIZED_VIEW_COMMENT.equals(comment)) {
                        yield TRINO_MATERIALIZED_VIEW;
                    }
                    yield OTHER_VIEW;
                }
                case "MATERIALIZED_VIEW" -> {
                    if (TableInfo.ICEBERG_MATERIALIZED_VIEW_COMMENT.equals(comment)) {
                        yield TRINO_MATERIALIZED_VIEW;
                    }
                    yield OTHER_MATERIALIZED_VIEW;
                }
                default -> TABLE;
            };
        }
    }
}

