/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.type;

import io.airlift.slice.SizeOf;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.TypeInfo;
import java.util.Objects;

public final class MapTypeInfo
extends TypeInfo {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MapTypeInfo.class);
    private final TypeInfo keyTypeInfo;
    private final TypeInfo valueTypeInfo;

    MapTypeInfo(TypeInfo keyTypeInfo, TypeInfo valueTypeInfo) {
        this.keyTypeInfo = Objects.requireNonNull(keyTypeInfo, "keyTypeInfo is null");
        this.valueTypeInfo = Objects.requireNonNull(valueTypeInfo, "valueTypeInfo is null");
    }

    @Override
    public String getTypeName() {
        return "map<" + this.keyTypeInfo.getTypeName() + "," + this.valueTypeInfo.getTypeName() + ">";
    }

    @Override
    public Category getCategory() {
        return Category.MAP;
    }

    public TypeInfo getMapKeyTypeInfo() {
        return this.keyTypeInfo;
    }

    public TypeInfo getMapValueTypeInfo() {
        return this.valueTypeInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MapTypeInfo)) return false;
        MapTypeInfo o = (MapTypeInfo)other;
        if (!this.keyTypeInfo.equals(o.keyTypeInfo)) return false;
        if (!this.valueTypeInfo.equals(o.valueTypeInfo)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyTypeInfo, this.valueTypeInfo);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyTypeInfo.getRetainedSizeInBytes() + this.valueTypeInfo.getRetainedSizeInBytes();
    }
}

