/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.trino.metastore.HiveType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Column {
    private final String name;
    private final HiveType type;
    private final Optional<String> comment;
    private final Map<String, String> properties;

    @JsonCreator
    public Column(@JsonProperty(value="name") String name, @JsonProperty(value="type") HiveType type, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="properties") Map<String, String> properties) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return Objects.equals(this.name, column.name) && Objects.equals(this.type, column.type) && Objects.equals(this.comment, column.comment) && Objects.equals(this.properties, column.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment, this.properties);
    }

    public Column withName(String newColumnName) {
        return new Column(newColumnName, this.type, this.comment, this.properties);
    }

    public Column withComment(Optional<String> comment) {
        return new Column(this.name, this.type, comment, this.properties);
    }
}

