/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.trino.metastore.Column;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.MetastoreErrorCode;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.Storage;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@Immutable
public class Table {
    public static final String TABLE_COMMENT = "comment";
    private final String databaseName;
    private final String tableName;
    private final Optional<String> owner;
    private final String tableType;
    private final List<Column> dataColumns;
    private final List<Column> partitionColumns;
    private final Storage storage;
    private final Map<String, String> parameters;
    private final Optional<String> viewOriginalText;
    private final Optional<String> viewExpandedText;
    private final OptionalLong writeId;

    @JsonCreator
    public Table(@JsonProperty(value="databaseName") String databaseName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="owner") Optional<String> owner, @JsonProperty(value="tableType") String tableType, @JsonProperty(value="storage") Storage storage, @JsonProperty(value="dataColumns") List<Column> dataColumns, @JsonProperty(value="partitionColumns") List<Column> partitionColumns, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="viewOriginalText") Optional<String> viewOriginalText, @JsonProperty(value="viewExpandedText") Optional<String> viewExpandedText, @JsonProperty(value="writeId") OptionalLong writeId) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.viewOriginalText = Objects.requireNonNull(viewOriginalText, "viewOriginalText is null");
        this.viewExpandedText = Objects.requireNonNull(viewExpandedText, "viewExpandedText is null");
        this.writeId = Objects.requireNonNull(writeId, "writeId is null");
    }

    @JsonProperty
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.databaseName, this.tableName);
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty
    public String getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public List<Column> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Optional<Column> getColumn(String name) {
        return Stream.concat(this.partitionColumns.stream(), this.dataColumns.stream()).filter(column -> column.getName().equals(name)).findFirst();
    }

    @JsonProperty
    public Storage getStorage() {
        return this.storage;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public Optional<String> getViewOriginalText() {
        return this.viewOriginalText;
    }

    @JsonProperty
    public Optional<String> getViewExpandedText() {
        return this.viewExpandedText;
    }

    @JsonProperty
    public OptionalLong getWriteId() {
        return this.writeId;
    }

    public Table withComment(Optional<String> comment) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(this.parameters);
        comment.ifPresentOrElse(value -> parameters.put(TABLE_COMMENT, (String)value), () -> parameters.remove(TABLE_COMMENT));
        return Table.builder(this).setParameters(parameters).build();
    }

    public Table withOwner(HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        return Table.builder(this).setOwner(Optional.of(principal.getName())).build();
    }

    public Table withColumnComment(String columnName, Optional<String> columnComment) {
        boolean found = false;
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column dataColumn : this.dataColumns) {
            if (dataColumn.getName().equals(columnName)) {
                if (found) {
                    throw new TrinoException((ErrorCodeSupplier)MetastoreErrorCode.HIVE_INVALID_METADATA, "Table %s.%s has multiple columns named %s".formatted(this.databaseName, this.tableName, columnName));
                }
                dataColumn = dataColumn.withComment(columnComment);
                found = true;
            }
            newDataColumns.add((Object)dataColumn);
        }
        ImmutableList.Builder newPartitionColumns = ImmutableList.builder();
        for (Column partitionColumn : this.partitionColumns) {
            if (partitionColumn.getName().equals(columnName)) {
                if (found) {
                    throw new TrinoException((ErrorCodeSupplier)MetastoreErrorCode.HIVE_INVALID_METADATA, "Table %s.%s has multiple columns named %s".formatted(this.databaseName, this.tableName, columnName));
                }
                partitionColumn = partitionColumn.withComment(columnComment);
                found = true;
            }
            newPartitionColumns.add((Object)partitionColumn);
        }
        if (!found) {
            throw new ColumnNotFoundException(this.getSchemaTableName(), columnName);
        }
        return Table.builder(this).setDataColumns((List<Column>)newDataColumns.build()).setPartitionColumns((List<Column>)newPartitionColumns.build()).build();
    }

    public Table withAddColumn(Column newColumn) {
        if (this.dataColumns.stream().map(Column::getName).anyMatch(columnName -> columnName.equals(newColumn.getName())) || this.partitionColumns.stream().map(Column::getName).anyMatch(columnName -> columnName.equals(newColumn.getName()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table %s.%s already has a column named %s".formatted(this.databaseName, this.tableName, newColumn.getName()));
        }
        return Table.builder(this).addDataColumn(newColumn).build();
    }

    public Table withDropColumn(String columnName) {
        block9: {
            block8: {
                if (this.partitionColumns.stream().map(Column::getName).anyMatch(columnName::equals)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition columns");
                }
                if (this.storage.getBucketProperty().stream().flatMap(bucket -> bucket.bucketedBy().stream()).anyMatch(columnName::equals)) break block8;
                if (!this.storage.getBucketProperty().stream().flatMap(bucket -> bucket.sortedBy().stream()).map(SortingColumn::columnName).anyMatch(columnName::equals)) break block9;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop bucket column %s.%s.%s".formatted(this.databaseName, this.tableName, columnName));
        }
        boolean found = false;
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column dataColumn : this.dataColumns) {
            if (dataColumn.getName().equals(columnName)) {
                found = true;
                continue;
            }
            newDataColumns.add((Object)dataColumn);
        }
        if (!found) {
            throw new ColumnNotFoundException(this.getSchemaTableName(), columnName);
        }
        ImmutableList dataColumns = newDataColumns.build();
        if (dataColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the only non-partition column in a table");
        }
        return Table.builder(this).setDataColumns((List<Column>)dataColumns).build();
    }

    public Table withRenameColumn(String oldColumnName, String newColumnName) {
        block13: {
            block12: {
                if (this.partitionColumns.stream().map(Column::getName).anyMatch(oldColumnName::equals)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
                }
                if (this.dataColumns.stream().map(Column::getName).anyMatch(newColumnName::equals)) break block12;
                if (!this.partitionColumns.stream().map(Column::getName).anyMatch(newColumnName::equals)) break block13;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table %s.%s already has a column named %s".formatted(this.databaseName, this.tableName, newColumnName));
        }
        boolean found = false;
        ImmutableList.Builder newDataColumns = ImmutableList.builder();
        for (Column dataColumn : this.dataColumns) {
            if (dataColumn.getName().equals(oldColumnName)) {
                newDataColumns.add((Object)dataColumn.withName(newColumnName));
                found = true;
                continue;
            }
            newDataColumns.add((Object)dataColumn);
        }
        if (!found) {
            throw new ColumnNotFoundException(this.getSchemaTableName(), oldColumnName);
        }
        Builder builder = Table.builder(this).setDataColumns((List<Column>)newDataColumns.build());
        if (this.storage.getBucketProperty().isPresent()) {
            HiveBucketProperty bucketProperty = this.storage.getBucketProperty().get();
            ImmutableList.Builder newBucketColumns = ImmutableList.builder();
            for (String bucketColumn : bucketProperty.bucketedBy()) {
                if (bucketColumn.equals(oldColumnName)) {
                    newBucketColumns.add((Object)newColumnName);
                    continue;
                }
                newBucketColumns.add((Object)bucketColumn);
            }
            ImmutableList.Builder newSortedColumns = ImmutableList.builder();
            for (SortingColumn sortingColumn : bucketProperty.sortedBy()) {
                if (sortingColumn.columnName().equals(oldColumnName)) {
                    newSortedColumns.add((Object)new SortingColumn(newColumnName, sortingColumn.order()));
                    continue;
                }
                newSortedColumns.add((Object)sortingColumn);
            }
            builder.getStorageBuilder().setBucketProperty(new HiveBucketProperty((List<String>)newBucketColumns.build(), bucketProperty.bucketCount(), (List<SortingColumn>)newSortedColumns.build()));
        }
        return builder.build();
    }

    public Table withParameters(Map<String, String> newParameters) {
        return Table.builder(this).setParameters(newParameters).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Table table) {
        return new Builder(table);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).add("owner", this.owner).add("tableType", (Object)this.tableType).add("dataColumns", this.dataColumns).add("partitionColumns", this.partitionColumns).add("storage", (Object)this.storage).add("parameters", this.parameters).add("viewOriginalText", this.viewOriginalText).add("viewExpandedText", this.viewExpandedText).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.databaseName, table.databaseName) && Objects.equals(this.tableName, table.tableName) && Objects.equals(this.owner, table.owner) && Objects.equals(this.tableType, table.tableType) && Objects.equals(this.dataColumns, table.dataColumns) && Objects.equals(this.partitionColumns, table.partitionColumns) && Objects.equals(this.storage, table.storage) && Objects.equals(this.parameters, table.parameters) && Objects.equals(this.viewOriginalText, table.viewOriginalText) && Objects.equals(this.viewExpandedText, table.viewExpandedText);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName, this.owner, this.tableType, this.dataColumns, this.partitionColumns, this.storage, this.parameters, this.viewOriginalText, this.viewExpandedText);
    }

    public static class Builder {
        private final Storage.Builder storageBuilder;
        private String databaseName;
        private String tableName;
        private Optional<String> owner;
        private String tableType;
        private List<Column> dataColumns = new ArrayList<Column>();
        private List<Column> partitionColumns = new ArrayList<Column>();
        private Map<String, String> parameters = new LinkedHashMap<String, String>();
        private Optional<String> viewOriginalText = Optional.empty();
        private Optional<String> viewExpandedText = Optional.empty();
        private OptionalLong writeId = OptionalLong.empty();

        private Builder() {
            this.storageBuilder = Storage.builder();
        }

        private Builder(Table table) {
            this.databaseName = table.databaseName;
            this.tableName = table.tableName;
            this.owner = table.owner;
            this.tableType = table.tableType;
            this.storageBuilder = Storage.builder(table.getStorage());
            this.dataColumns = new ArrayList<Column>(table.dataColumns);
            this.partitionColumns = new ArrayList<Column>(table.partitionColumns);
            this.parameters = new LinkedHashMap<String, String>(table.parameters);
            this.viewOriginalText = table.viewOriginalText;
            this.viewExpandedText = table.viewExpandedText;
            this.writeId = table.writeId;
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setOwner(Optional<String> owner) {
            this.owner = owner;
            return this;
        }

        public Builder setTableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public Storage.Builder getStorageBuilder() {
            return this.storageBuilder;
        }

        public Builder setDataColumns(List<Column> dataColumns) {
            this.dataColumns = new ArrayList<Column>(dataColumns);
            return this;
        }

        public Builder addDataColumn(Column dataColumn) {
            this.dataColumns.add(dataColumn);
            return this;
        }

        public Builder setPartitionColumns(List<Column> partitionColumns) {
            this.partitionColumns = new ArrayList<Column>(partitionColumns);
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            this.parameters = new LinkedHashMap<String, String>(parameters);
            return this;
        }

        public Builder setParameter(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        public Builder setParameter(String key, Optional<String> value) {
            if (value.isEmpty()) {
                this.parameters.remove(key);
            } else {
                this.parameters.put(key, value.get());
            }
            return this;
        }

        public Builder setViewOriginalText(Optional<String> viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public Builder setViewExpandedText(Optional<String> viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public Builder setWriteId(OptionalLong writeId) {
            this.writeId = writeId;
            return this;
        }

        public Builder withStorage(Consumer<Storage.Builder> consumer) {
            consumer.accept(this.storageBuilder);
            return this;
        }

        public Builder apply(Function<Builder, Builder> function) {
            return function.apply(this);
        }

        public Table build() {
            return new Table(this.databaseName, this.tableName, this.owner, this.tableType, this.storageBuilder.build(), this.dataColumns, this.partitionColumns, this.parameters, this.viewOriginalText, this.viewExpandedText, this.writeId);
        }
    }
}

