/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metastore.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.units.Duration;
import io.trino.cache.CacheStatsMBean;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.metastore.AcidOperation;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.Database;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.Partitions;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.metastore.cache.HivePartitionName;
import io.trino.metastore.cache.HiveTableName;
import io.trino.metastore.cache.PartitionFilter;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public final class CachingHiveMetastore
implements HiveMetastore {
    private final HiveMetastore delegate;
    private final Set<ObjectType> cacheMissing;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<HiveTableName, Optional<Table>> tableCache;
    private final LoadingCache<String, List<TableInfo>> tablesCacheNew;
    private final Cache<HiveTableName, AtomicReference<Map<String, HiveColumnStatistics>>> tableColumnStatisticsCache;
    private final LoadingCache<TablesWithParameterCacheKey, List<String>> tableNamesWithParametersCache;
    private final Cache<HivePartitionName, AtomicReference<Map<String, HiveColumnStatistics>>> partitionStatisticsCache;
    private final Cache<HivePartitionName, AtomicReference<Optional<Partition>>> partitionCache;
    private final LoadingCache<PartitionFilter, Optional<List<String>>> partitionFilterCache;
    private final LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final LoadingCache<String, Set<String>> rolesCache;
    private final LoadingCache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final LoadingCache<String, Optional<String>> configValuesCache;

    public static CachingHiveMetastore createPerTransactionCache(HiveMetastore delegate, long maximumSize) {
        return new CachingHiveMetastore(delegate, (Set<ObjectType>)ImmutableSet.copyOf((Object[])ObjectType.values()), new CacheFactory(maximumSize), new CacheFactory(maximumSize), new CacheFactory(maximumSize), new CacheFactory(maximumSize));
    }

    public static CachingHiveMetastore createCachingHiveMetastore(HiveMetastore delegate, Duration metadataCacheTtl, Duration statsCacheTtl, Optional<Duration> refreshInterval, Executor refreshExecutor, long maximumSize, StatsRecording statsRecording, boolean partitionCacheEnabled, Set<ObjectType> cacheMissing) {
        Objects.requireNonNull(refreshExecutor, "refreshExecutor is null");
        long metadataCacheMillis = metadataCacheTtl.toMillis();
        long statsCacheMillis = statsCacheTtl.toMillis();
        Preconditions.checkArgument((metadataCacheMillis > 0L || statsCacheMillis > 0L ? 1 : 0) != 0, (Object)"Cache not enabled");
        OptionalLong refreshMillis = refreshInterval.stream().mapToLong(Duration::toMillis).findAny();
        CacheFactory cacheFactory = CacheFactory.NEVER_CACHE;
        CacheFactory partitionCacheFactory = CacheFactory.NEVER_CACHE;
        if (metadataCacheMillis > 0L) {
            cacheFactory = new CacheFactory(OptionalLong.of(metadataCacheMillis), refreshMillis, Optional.of(refreshExecutor), maximumSize, statsRecording);
            if (partitionCacheEnabled) {
                partitionCacheFactory = cacheFactory;
            }
        }
        CacheFactory statsCacheFactory = CacheFactory.NEVER_CACHE;
        CacheFactory partitionStatsCacheFactory = CacheFactory.NEVER_CACHE;
        if (statsCacheMillis > 0L) {
            statsCacheFactory = new CacheFactory(OptionalLong.of(statsCacheMillis), refreshMillis, Optional.of(refreshExecutor), maximumSize, statsRecording);
            if (partitionCacheEnabled) {
                partitionStatsCacheFactory = statsCacheFactory;
            }
        }
        return new CachingHiveMetastore(delegate, cacheMissing, cacheFactory, partitionCacheFactory, statsCacheFactory, partitionStatsCacheFactory);
    }

    private CachingHiveMetastore(HiveMetastore delegate, Set<ObjectType> cacheMissing, CacheFactory cacheFactory, CacheFactory partitionCacheFactory, CacheFactory statsCacheFactory, CacheFactory partitionStatsCacheFactory) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cacheMissing = cacheMissing;
        this.databaseNamesCache = cacheFactory.buildCache(string -> this.loadAllDatabases());
        this.databaseCache = cacheFactory.buildCache(this::loadDatabase);
        this.tablesCacheNew = cacheFactory.buildCache(this::loadTablesNew);
        this.tableColumnStatisticsCache = statsCacheFactory.buildCache(this::refreshTableColumnStatistics);
        this.tableCache = cacheFactory.buildCache(this::loadTable);
        this.tableNamesWithParametersCache = cacheFactory.buildCache(this::loadTablesMatchingParameter);
        this.tablePrivilegesCache = cacheFactory.buildCache(key -> this.loadTablePrivileges(key.database(), key.table(), key.owner(), key.principal()));
        this.rolesCache = cacheFactory.buildCache(string -> this.loadRoles());
        this.roleGrantsCache = cacheFactory.buildCache(this::loadRoleGrants);
        this.configValuesCache = cacheFactory.buildCache(this::loadConfigValue);
        this.partitionStatisticsCache = partitionStatsCacheFactory.buildBulkCache();
        this.partitionFilterCache = partitionCacheFactory.buildCache(this::loadPartitionNamesByFilter);
        this.partitionCache = partitionCacheFactory.buildBulkCache();
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tablesCacheNew.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.tableNamesWithParametersCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tablePrivilegesCache.invalidateAll();
        this.tableColumnStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    public void flushPartitionCache(String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        String providedPartitionName = Partitions.makePartName(partitionColumns, partitionValues);
        this.invalidatePartitionCache(schemaName, tableName, partitionNameToCheck -> partitionNameToCheck.map(value -> value.equals(providedPartitionName)).orElse(false));
    }

    private AtomicReference<Map<String, HiveColumnStatistics>> refreshTableColumnStatistics(HiveTableName tableName, AtomicReference<Map<String, HiveColumnStatistics>> currentValueHolder) {
        Map<String, HiveColumnStatistics> currentValue = currentValueHolder.get();
        if (currentValue == null) {
            return currentValueHolder;
        }
        Map<String, HiveColumnStatistics> columnStatistics = this.delegate.getTableColumnStatistics(tableName.getDatabaseName(), tableName.getTableName(), currentValue.keySet());
        return new AtomicReference<Map<String, HiveColumnStatistics>>(columnStatistics);
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            Object value = cache.getUnchecked(key);
            Preconditions.checkState((!(value instanceof Optional) ? 1 : 0) != 0, (Object)"This must not be used for caches with Optional values, as it doesn't implement cacheMissing logic. Use getOptional()");
            return (V)value;
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
    }

    private <K, V> Optional<V> getOptional(ObjectType objectType, LoadingCache<K, Optional<V>> cache, K key) {
        try {
            boolean valueIsPresent;
            Optional value = (Optional)cache.getIfPresent(key);
            boolean bl = valueIsPresent = value != null;
            if (valueIsPresent) {
                if (value.isPresent() || this.cacheMissing.contains((Object)objectType)) {
                    return value;
                }
                cache.invalidate(key);
            }
            return (Optional)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
    }

    private static <K, V> V getWithValueHolder(Cache<K, AtomicReference<V>> cache, K key, Supplier<V> loader) {
        AtomicReference valueHolder = (AtomicReference)CacheUtils.uncheckedCacheGet(cache, key, AtomicReference::new);
        Object value = valueHolder.get();
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            throw new CacheLoader.InvalidCacheLoadException("Failed to return a value for " + String.valueOf(key));
        }
        valueHolder.compareAndSet(null, value);
        return value;
    }

    private static <K, V> V getIncrementally(Cache<K, AtomicReference<V>> cache, K key, Predicate<V> isSufficient, Supplier<V> loader, Function<V, V> incrementalLoader, BinaryOperator<V> merger) {
        AtomicReference valueHolder = (AtomicReference)CacheUtils.uncheckedCacheGet(cache, key, AtomicReference::new);
        Object oldValue = valueHolder.get();
        if (oldValue != null && isSufficient.test(oldValue)) {
            return oldValue;
        }
        V newValue = oldValue == null ? loader.get() : incrementalLoader.apply(oldValue);
        Verify.verifyNotNull(newValue, (String)"loader returned null for %s", (Object[])new Object[]{key});
        Object merged = merger.apply(oldValue, newValue);
        if (!valueHolder.compareAndSet(oldValue, merged)) {
            valueHolder.accumulateAndGet(newValue, merger);
        }
        return (V)merged;
    }

    private static <K, V> Map<K, V> getAll(Cache<K, AtomicReference<V>> cache, Iterable<K> keys, Function<Set<K>, Map<K, V>> bulkLoader) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableMap.Builder toLoadBuilder = ImmutableMap.builder();
        for (K key2 : keys) {
            AtomicReference valueHolder2 = (AtomicReference)CacheUtils.uncheckedCacheGet(cache, key2, AtomicReference::new);
            Object value = valueHolder2.get();
            if (value != null) {
                result.put(key2, value);
                continue;
            }
            toLoadBuilder.put(key2, (Object)valueHolder2);
        }
        ImmutableMap toLoad = toLoadBuilder.buildOrThrow();
        if (toLoad.isEmpty()) {
            return result.buildOrThrow();
        }
        Map newEntries = bulkLoader.apply(Collections.unmodifiableSet(toLoad.keySet()));
        toLoad.forEach((key, valueHolder) -> {
            Object value = newEntries.get(key);
            if (value == null) {
                throw new CacheLoader.InvalidCacheLoadException("Failed to return a value for " + String.valueOf(key));
            }
            result.put(key, value);
            valueHolder.compareAndSet(null, value);
        });
        return result.buildOrThrow();
    }

    private static <K, V> Map<K, V> getAll(Cache<K, AtomicReference<V>> cache, Iterable<K> keys, Function<Collection<K>, Map<K, V>> bulkLoader, Predicate<V> isSufficient, BinaryOperator<V> merger) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        HashMap<Object, AtomicReference> toLoad = new HashMap<Object, AtomicReference>();
        keys.forEach(key -> {
            AtomicReference currentValueHolder = (AtomicReference)CacheUtils.uncheckedCacheGet((Cache)cache, (Object)key, AtomicReference::new);
            Object currentValue = currentValueHolder.get();
            if (currentValue != null && isSufficient.test(currentValue)) {
                result.put(key, currentValue);
            } else {
                toLoad.put(key, currentValueHolder);
            }
        });
        if (toLoad.isEmpty()) {
            return result.buildOrThrow();
        }
        Map newEntries = bulkLoader.apply(toLoad.keySet());
        toLoad.forEach((key, valueHolder) -> {
            Object newValue = newEntries.get(key);
            Verify.verifyNotNull(newValue, (String)"loader returned null for %s", (Object[])new Object[]{key});
            Object merged = valueHolder.accumulateAndGet(newValue, merger);
            result.put(key, merged);
        });
        return result.buildOrThrow();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.getOptional(ObjectType.OTHER, this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.getOptional(ObjectType.OTHER, this.tableCache, HiveTableName.hiveTableName(databaseName, tableName));
    }

    private Optional<Table> loadTable(HiveTableName hiveTableName) {
        return this.delegate.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        Map columnStatistics = CachingHiveMetastore.getIncrementally(this.tableColumnStatisticsCache, HiveTableName.hiveTableName(databaseName, tableName), currentStatistics -> currentStatistics.keySet().containsAll(columnNames), () -> this.delegate.getTableColumnStatistics(databaseName, tableName, columnNames), currentStatistics -> {
            Sets.SetView missingColumns = Sets.difference((Set)columnNames, currentStatistics.keySet());
            return this.delegate.getTableColumnStatistics(databaseName, tableName, (Set<String>)missingColumns);
        }, (currentStats, newStats) -> this.mergeColumnStatistics((Map<String, HiveColumnStatistics>)currentStats, (Map<String, HiveColumnStatistics>)newStats, columnNames));
        return CachingHiveMetastore.removeEmptyColumnStatistics(columnNames, columnStatistics);
    }

    @Override
    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        List<HivePartitionName> hivePartitionNames = partitionNames.stream().map(partitionName -> HivePartitionName.hivePartitionName(hiveTableName, partitionName)).toList();
        Map<HivePartitionName, Map> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, hivePartitionNames, missingPartitions -> this.loadPartitionsColumnStatistics(databaseName, tableName, columnNames, (Collection<HivePartitionName>)missingPartitions), currentStats -> currentStats.keySet().containsAll(columnNames), (currentStats, newStats) -> this.mergeColumnStatistics((Map<String, HiveColumnStatistics>)currentStats, (Map<String, HiveColumnStatistics>)newStats, columnNames));
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)entry.getKey()).getPartitionName().orElseThrow(), entry -> CachingHiveMetastore.removeEmptyColumnStatistics(columnNames, (Map)entry.getValue())));
    }

    @Override
    public boolean useSparkTableStatistics() {
        return this.delegate.useSparkTableStatistics();
    }

    private static Map<String, HiveColumnStatistics> removeEmptyColumnStatistics(Set<String> columnNames, Map<String, HiveColumnStatistics> columnStatistics) {
        return (Map)columnStatistics.entrySet().stream().filter(entry -> columnNames.contains(entry.getKey()) && !((HiveColumnStatistics)entry.getValue()).equals(HiveColumnStatistics.empty())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, HiveColumnStatistics> mergeColumnStatistics(Map<String, HiveColumnStatistics> currentStats, Map<String, HiveColumnStatistics> newStats, Set<String> dataColumns) {
        Objects.requireNonNull(newStats, "newStats is null");
        ImmutableMap.Builder columnStatisticsBuilder = ImmutableMap.builder();
        if (this.cacheMissing.contains((Object)ObjectType.STATS)) {
            columnStatisticsBuilder.putAll(Iterables.transform(dataColumns, column -> new AbstractMap.SimpleEntry<String, HiveColumnStatistics>((String)column, HiveColumnStatistics.empty())));
        }
        if (currentStats != null) {
            columnStatisticsBuilder.putAll(currentStats);
        }
        columnStatisticsBuilder.putAll(newStats);
        return columnStatisticsBuilder.buildKeepingLast();
    }

    private Map<HivePartitionName, Map<String, HiveColumnStatistics>> loadPartitionsColumnStatistics(String databaseName, String tableName, Set<String> columnNames, Collection<HivePartitionName> partitionNamesToLoad) {
        if (partitionNamesToLoad.isEmpty()) {
            return ImmutableMap.of();
        }
        Set partitionsToLoad = (Set)partitionNamesToLoad.stream().map(partitionName -> partitionName.getPartitionName().orElseThrow()).collect(ImmutableSet.toImmutableSet());
        Map<String, Map<String, HiveColumnStatistics>> columnStatistics = this.delegate.getPartitionColumnStatistics(databaseName, tableName, partitionsToLoad, columnNames);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (HivePartitionName partitionName2 : partitionNamesToLoad) {
            result.put((Object)partitionName2, columnStatistics.getOrDefault(partitionName2.getPartitionName().orElseThrow(), (Map<String, HiveColumnStatistics>)ImmutableMap.of()));
        }
        return result.buildOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(String databaseName, String tableName, OptionalLong acidWriteId, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        try {
            this.delegate.updateTableStatistics(databaseName, tableName, acidWriteId, mode, statisticsUpdate);
        }
        finally {
            HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
            this.tableColumnStatisticsCache.invalidate((Object)hiveTableName);
            this.tableCache.invalidate((Object)hiveTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        try {
            this.delegate.updatePartitionStatistics(table, mode, partitionUpdates);
        }
        finally {
            partitionUpdates.keySet().forEach(partitionName -> {
                HivePartitionName hivePartitionName = HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName);
                this.partitionStatisticsCache.invalidate((Object)hivePartitionName);
                this.partitionCache.invalidate((Object)hivePartitionName);
            });
        }
    }

    @Override
    public List<TableInfo> getTables(String databaseName) {
        return CachingHiveMetastore.get(this.tablesCacheNew, databaseName);
    }

    private List<TableInfo> loadTablesNew(String databaseName) {
        return this.delegate.getTables(databaseName);
    }

    @Override
    public List<String> getTableNamesWithParameters(String databaseName, String parameterKey, Set<String> parameterValues) {
        TablesWithParameterCacheKey key = new TablesWithParameterCacheKey(databaseName, parameterKey, parameterValues);
        return CachingHiveMetastore.get(this.tableNamesWithParametersCache, key);
    }

    private List<String> loadTablesMatchingParameter(TablesWithParameterCacheKey key) {
        return this.delegate.getTableNamesWithParameters(key.databaseName(), key.parameterKey(), key.parameterValues());
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.delegate.createDatabase(database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        try {
            this.delegate.dropDatabase(databaseName, deleteData);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            this.delegate.renameDatabase(databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        try {
            this.delegate.setDatabaseOwner(databaseName, principal);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    private void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate((Object)databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.createTable(table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.delegate.dropTable(databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges, Map<String, String> environmentContext) {
        try {
            this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges, environmentContext);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        try {
            this.delegate.commentTable(databaseName, tableName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        try {
            this.delegate.setTableOwner(databaseName, tableName, principal);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        try {
            this.delegate.commentColumn(databaseName, tableName, columnName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        try {
            this.delegate.dropColumn(databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    public void invalidateTable(String databaseName, String tableName) {
        HiveTableName hiveTableName = new HiveTableName(databaseName, tableName);
        this.tableCache.invalidate((Object)hiveTableName);
        this.tablesCacheNew.invalidate((Object)databaseName);
        this.tableNamesWithParametersCache.invalidateAll();
        CacheUtils.invalidateAllIf(this.tablePrivilegesCache, userTableKey -> userTableKey.matches(databaseName, tableName));
        this.tableColumnStatisticsCache.invalidate((Object)hiveTableName);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        return CachingHiveMetastore.getWithValueHolder(this.partitionCache, HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionValues), () -> this.delegate.getPartition(table, partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.getOptional(ObjectType.PARTITION, this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, columnNames, partitionKeysFilter));
    }

    private Optional<List<String>> loadPartitionNamesByFilter(PartitionFilter partitionFilter) {
        return this.delegate.getPartitionNamesByFilter(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getPartitionColumnNames(), partitionFilter.getPartitionKeysFilter());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        List names = (List)partitionNames.stream().map(name -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), name)).collect(ImmutableList.toImmutableList());
        Map<HivePartitionName, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names, namesToLoad -> this.loadPartitionsByNames(table, (Iterable<? extends HivePartitionName>)namesToLoad));
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        for (Map.Entry<HivePartitionName, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getPartitionName().orElseThrow(), entry.getValue());
        }
        return partitionsByName.buildOrThrow();
    }

    private Map<HivePartitionName, Optional<Partition>> loadPartitionsByNames(Table table, Iterable<? extends HivePartitionName> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)hivePartitionName.getHiveTableName());
            partitionsToFetch.add(hivePartitionName.getPartitionName().orElseThrow());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(table, partitionsToFetch);
        for (HivePartitionName hivePartitionName : partitionNames) {
            partitions.put((Object)hivePartitionName, map.getOrDefault(hivePartitionName.getPartitionName().orElseThrow(), Optional.empty()));
        }
        return partitions.buildOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        try {
            this.delegate.addPartitions(databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        try {
            this.delegate.alterPartition(databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.delegate.createRole(role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.delegate.dropRole(role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles() {
        return CachingHiveMetastore.get(this.rolesCache, "");
    }

    private Set<String> loadRoles() {
        return this.delegate.listRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.grantRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        try {
            this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return CachingHiveMetastore.get(this.roleGrantsCache, principal);
    }

    private Set<RoleGrant> loadRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        this.invalidatePartitionCache(databaseName, tableName, partitionName -> true);
    }

    private void invalidatePartitionCache(String databaseName, String tableName, Predicate<Optional<String>> partitionPredicate) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        Predicate<HivePartitionName> hivePartitionPredicate = partitionName -> partitionName.getHiveTableName().equals(hiveTableName) && partitionPredicate.test(partitionName.getPartitionName());
        CacheUtils.invalidateAllIf(this.partitionCache, hivePartitionPredicate);
        CacheUtils.invalidateAllIf(this.partitionFilterCache, partitionFilter -> partitionFilter.getHiveTableName().equals(hiveTableName));
        CacheUtils.invalidateAllIf(this.partitionStatisticsCache, hivePartitionPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        try {
            this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
        }
        finally {
            this.invalidateTablePrivilegeCacheEntries(databaseName, tableName, tableOwner, grantee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        try {
            this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
        }
        finally {
            this.invalidateTablePrivilegeCacheEntries(databaseName, tableName, tableOwner, grantee);
        }
    }

    private void invalidateTablePrivilegeCacheEntries(String databaseName, String tableName, String tableOwner, HivePrincipal grantee) {
        this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.of(grantee), databaseName, tableName, Optional.of(tableOwner)));
        this.tablePrivilegesCache.invalidate((Object)new UserTableKey(Optional.empty(), databaseName, tableName, Optional.of(tableOwner)));
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return CachingHiveMetastore.get(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName, tableOwner));
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        return this.getOptional(ObjectType.OTHER, this.configValuesCache, name);
    }

    private Optional<String> loadConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public void checkSupportsTransactions() {
        this.delegate.checkSupportsTransactions();
    }

    @Override
    public long openTransaction(AcidTransactionOwner transactionOwner) {
        return this.delegate.openTransaction(transactionOwner);
    }

    @Override
    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(transactionId);
    }

    @Override
    public void abortTransaction(long transactionId) {
        this.delegate.abortTransaction(transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(long transactionId) {
        this.delegate.sendTransactionHeartbeat(transactionId);
    }

    @Override
    public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(transactionOwner, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(tables, currentTransactionId);
    }

    private Set<HivePrivilegeInfo> loadTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    @Override
    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    @Override
    public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, AcidOperation operation, boolean isDynamicPartitionWrite) {
        this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, operation, isDynamicPartitionWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        try {
            this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
        }
        finally {
            this.invalidateTable(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        try {
            this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
        }
        finally {
            this.invalidatePartitionCache(dbName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterTransactionalTable(Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.alterTransactionalTable(table, transactionId, writeId, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    @Override
    public boolean functionExists(String databaseName, String functionName, String signatureToken) {
        return this.delegate.functionExists(databaseName, functionName, signatureToken);
    }

    @Override
    public Collection<LanguageFunction> getAllFunctions(String databaseName) {
        return this.delegate.getAllFunctions(databaseName);
    }

    @Override
    public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
        return this.delegate.getFunctions(databaseName, functionName);
    }

    @Override
    public void createFunction(String databaseName, String functionName, LanguageFunction function) {
        this.delegate.createFunction(databaseName, functionName, function);
    }

    @Override
    public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
        this.delegate.replaceFunction(databaseName, functionName, function);
    }

    @Override
    public void dropFunction(String databaseName, String functionName, String signatureToken) {
        this.delegate.dropFunction(databaseName, functionName, signatureToken);
    }

    private static <K, V> LoadingCache<K, V> buildCache(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Optional<Executor> refreshExecutor, long maximumSize, StatsRecording statsRecording, CacheLoader<K, V> cacheLoader) {
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        Preconditions.checkArgument((refreshMillis.isEmpty() || refreshExecutor.isPresent() ? 1 : 0) != 0, (Object)"refreshMillis is provided but refreshExecutor is not");
        if (refreshMillis.isPresent() && (expiresAfterWriteMillis.isEmpty() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
            cacheLoader = CacheLoader.asyncReloading(cacheLoader, (Executor)refreshExecutor.orElseThrow(() -> new IllegalArgumentException("Executor not provided")));
        }
        cacheBuilder.maximumSize(maximumSize);
        if (statsRecording == StatsRecording.ENABLED) {
            cacheBuilder.recordStats();
        }
        cacheBuilder.shareNothingWhenDisabled();
        return cacheBuilder.build(cacheLoader);
    }

    private static <K, V> Cache<K, AtomicReference<V>> buildBulkCache(OptionalLong expiresAfterWriteMillis, long maximumSize, StatsRecording statsRecording) {
        EvictableCacheBuilder cacheBuilder = EvictableCacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder.maximumSize(maximumSize);
        if (statsRecording == StatsRecording.ENABLED) {
            cacheBuilder.recordStats();
        }
        cacheBuilder.shareNothingWhenDisabled();
        return cacheBuilder.build();
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseStats() {
        return new CacheStatsMBean(this.databaseCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getDatabaseNamesStats() {
        return new CacheStatsMBean(this.databaseNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableStats() {
        return new CacheStatsMBean(this.tableCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableNamesStats() {
        return new CacheStatsMBean(this.tablesCacheNew);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableWithParameterStats() {
        return new CacheStatsMBean(this.tableNamesWithParametersCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableColumnStatisticsStats() {
        return new CacheStatsMBean(this.tableColumnStatisticsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionStatisticsStats() {
        return new CacheStatsMBean(this.partitionStatisticsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionStats() {
        return new CacheStatsMBean(this.partitionCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPartitionFilterStats() {
        return new CacheStatsMBean(this.partitionFilterCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTablePrivilegesStats() {
        return new CacheStatsMBean(this.tablePrivilegesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getRolesStats() {
        return new CacheStatsMBean(this.rolesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getRoleGrantsStats() {
        return new CacheStatsMBean(this.roleGrantsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getConfigValuesStats() {
        return new CacheStatsMBean(this.configValuesCache);
    }

    LoadingCache<String, Optional<Database>> getDatabaseCache() {
        return this.databaseCache;
    }

    LoadingCache<String, List<String>> getDatabaseNamesCache() {
        return this.databaseNamesCache;
    }

    LoadingCache<HiveTableName, Optional<Table>> getTableCache() {
        return this.tableCache;
    }

    LoadingCache<TablesWithParameterCacheKey, List<String>> getTableNamesWithParametersCache() {
        return this.tableNamesWithParametersCache;
    }

    public LoadingCache<String, List<TableInfo>> getTablesCacheNew() {
        return this.tablesCacheNew;
    }

    Cache<HiveTableName, AtomicReference<Map<String, HiveColumnStatistics>>> getTableColumnStatisticsCache() {
        return this.tableColumnStatisticsCache;
    }

    Cache<HivePartitionName, AtomicReference<Map<String, HiveColumnStatistics>>> getPartitionStatisticsCache() {
        return this.partitionStatisticsCache;
    }

    Cache<HivePartitionName, AtomicReference<Optional<Partition>>> getPartitionCache() {
        return this.partitionCache;
    }

    LoadingCache<PartitionFilter, Optional<List<String>>> getPartitionFilterCache() {
        return this.partitionFilterCache;
    }

    LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> getTablePrivilegesCache() {
        return this.tablePrivilegesCache;
    }

    LoadingCache<String, Set<String>> getRolesCache() {
        return this.rolesCache;
    }

    LoadingCache<HivePrincipal, Set<RoleGrant>> getRoleGrantsCache() {
        return this.roleGrantsCache;
    }

    LoadingCache<String, Optional<String>> getConfigValuesCache() {
        return this.configValuesCache;
    }

    public static enum ObjectType {
        PARTITION,
        STATS,
        OTHER;

    }

    private record CacheFactory(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, Optional<Executor> refreshExecutor, long maximumSize, StatsRecording statsRecording) {
        private static final CacheFactory NEVER_CACHE = new CacheFactory(OptionalLong.empty(), OptionalLong.empty(), Optional.empty(), 0L, StatsRecording.DISABLED);

        private CacheFactory(long maximumSize) {
            this(OptionalLong.empty(), OptionalLong.empty(), Optional.empty(), maximumSize, StatsRecording.DISABLED);
        }

        private CacheFactory {
            Objects.requireNonNull(expiresAfterWriteMillis, "expiresAfterWriteMillis is null");
            Preconditions.checkArgument((expiresAfterWriteMillis.isEmpty() || expiresAfterWriteMillis.getAsLong() > 0L ? 1 : 0) != 0, (Object)"expiresAfterWriteMillis must be empty or at least 1 millisecond");
            Objects.requireNonNull(refreshMillis, "refreshMillis is null");
            Preconditions.checkArgument((refreshMillis.isEmpty() || refreshMillis.getAsLong() > 0L ? 1 : 0) != 0, (Object)"refreshMillis must be empty or at least 1 millisecond");
            Objects.requireNonNull(refreshExecutor, "refreshExecutor is null");
            Objects.requireNonNull(statsRecording, "statsRecording is null");
        }

        public <K, V> LoadingCache<K, V> buildCache(Function<K, V> loader) {
            return CachingHiveMetastore.buildCache(this.expiresAfterWriteMillis, this.refreshMillis, this.refreshExecutor, this.maximumSize, this.statsRecording, CacheLoader.from(loader::apply));
        }

        public <K, V> Cache<K, V> buildCache(final BiFunction<K, V, V> loader) {
            CacheLoader cacheLoader = new CacheLoader<K, V>(this){

                public V load(K key) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<V> reload(K key, V oldValue) {
                    Objects.requireNonNull(key);
                    Objects.requireNonNull(oldValue);
                    return Futures.immediateFuture(loader.apply(key, oldValue));
                }
            };
            return CachingHiveMetastore.buildCache(this.expiresAfterWriteMillis, this.refreshMillis, this.refreshExecutor, this.maximumSize, this.statsRecording, cacheLoader);
        }

        public <K, V> Cache<K, AtomicReference<V>> buildBulkCache() {
            return CachingHiveMetastore.buildBulkCache(this.expiresAfterWriteMillis, this.maximumSize, this.statsRecording);
        }
    }

    public static enum StatsRecording {
        ENABLED,
        DISABLED;

    }

    record TablesWithParameterCacheKey(String databaseName, String parameterKey, Set<String> parameterValues) {
        TablesWithParameterCacheKey {
            Objects.requireNonNull(databaseName, "databaseName is null");
            Objects.requireNonNull(parameterKey, "parameterKey is null");
            Objects.requireNonNull(parameterValues, "parameterValues is null");
        }
    }

    record UserTableKey(Optional<HivePrincipal> principal, String database, String table, Optional<String> owner) {
        UserTableKey {
            Objects.requireNonNull(principal, "principal is null");
            Objects.requireNonNull(database, "database is null");
            Objects.requireNonNull(table, "table is null");
            Objects.requireNonNull(owner, "owner is null");
        }

        public boolean matches(String databaseName, String tableName) {
            return this.database.equals(databaseName) && this.table.equals(tableName);
        }
    }
}

