/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import io.airlift.slice.Slice;
import io.trino.plugin.ml.Dataset;
import io.trino.plugin.ml.FeatureUnitNormalizer;
import io.trino.plugin.ml.FeatureVector;
import io.trino.plugin.ml.LearnState;
import io.trino.plugin.ml.LibSvmUtils;
import io.trino.plugin.ml.ModelUtils;
import io.trino.plugin.ml.RegressorFeatureTransformer;
import io.trino.plugin.ml.SvmRegressor;
import io.trino.plugin.ml.type.RegressorType;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import java.util.Map;

@AggregationFunction(value="learn_libsvm_regressor", decomposable=false)
public final class LearnLibSvmRegressorAggregation {
    private LearnLibSvmRegressorAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LearnState state, @SqlType(value="bigint") long label, @SqlType(value="map(bigint,double)") Block features, @SqlType(value="varchar") Slice parameters) {
        LearnLibSvmRegressorAggregation.input(state, (double)label, features, parameters);
    }

    @InputFunction
    public static void input(@AggregationState LearnState state, @SqlType(value="double") double label, @SqlType(value="map(bigint,double)") Block features, @SqlType(value="varchar") Slice parameters) {
        state.getLabels().add(label);
        FeatureVector featureVector = ModelUtils.toFeatures(features);
        state.addMemoryUsage(featureVector.getEstimatedSize());
        state.getFeatureVectors().add(featureVector);
        state.setParameters(parameters);
    }

    @CombineFunction
    public static void combine(@AggregationState LearnState state, @AggregationState LearnState otherState) {
        throw new UnsupportedOperationException("LEARN must run on a single machine");
    }

    @OutputFunction(value="Regressor")
    public static void output(@AggregationState LearnState state, BlockBuilder out) {
        Dataset dataset = new Dataset(state.getLabels(), state.getFeatureVectors(), (Map<Integer, String>)state.getLabelEnumeration().inverse());
        RegressorFeatureTransformer model = new RegressorFeatureTransformer(new SvmRegressor(LibSvmUtils.parseParameters(state.getParameters().toStringUtf8())), new FeatureUnitNormalizer());
        model.train(dataset);
        RegressorType.REGRESSOR.writeSlice(out, ModelUtils.serialize(model));
    }
}

