/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import io.airlift.slice.Slice;
import io.trino.plugin.ml.ClassifierFeatureTransformer;
import io.trino.plugin.ml.Dataset;
import io.trino.plugin.ml.FeatureUnitNormalizer;
import io.trino.plugin.ml.FeatureVector;
import io.trino.plugin.ml.LearnState;
import io.trino.plugin.ml.LibSvmUtils;
import io.trino.plugin.ml.ModelUtils;
import io.trino.plugin.ml.StringClassifierAdapter;
import io.trino.plugin.ml.SvmClassifier;
import io.trino.plugin.ml.type.ClassifierType;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import java.util.Map;

@AggregationFunction(value="learn_libsvm_classifier", decomposable=false)
public final class LearnLibSvmVarcharClassifierAggregation {
    private LearnLibSvmVarcharClassifierAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LearnState state, @SqlType(value="varchar") Slice label, @SqlType(value="map(bigint,double)") Block features, @SqlType(value="varchar") Slice parameters) {
        state.getLabels().add(Double.valueOf(state.enumerateLabel(label.toStringUtf8())));
        FeatureVector featureVector = ModelUtils.toFeatures(features);
        state.addMemoryUsage(featureVector.getEstimatedSize());
        state.getFeatureVectors().add(featureVector);
        state.setParameters(parameters);
    }

    @CombineFunction
    public static void combine(@AggregationState LearnState state, @AggregationState LearnState otherState) {
        throw new UnsupportedOperationException("LEARN must run on a single machine");
    }

    @OutputFunction(value="Classifier(varchar)")
    public static void output(@AggregationState LearnState state, BlockBuilder out) {
        Dataset dataset = new Dataset(state.getLabels(), state.getFeatureVectors(), (Map<Integer, String>)state.getLabelEnumeration().inverse());
        StringClassifierAdapter model = new StringClassifierAdapter(new ClassifierFeatureTransformer(new SvmClassifier(LibSvmUtils.parseParameters(state.getParameters().toStringUtf8())), new FeatureUnitNormalizer()));
        model.train(dataset);
        ClassifierType.VARCHAR_CLASSIFIER.writeSlice(out, ModelUtils.serialize(model));
    }
}

