/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import io.trino.plugin.ml.AbstractSvmModel;
import io.trino.plugin.ml.FeatureVector;
import io.trino.plugin.ml.LibSvmUtils;
import io.trino.plugin.ml.Regressor;
import io.trino.plugin.ml.type.ModelType;
import io.trino.plugin.ml.type.RegressorType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Objects;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;

public class SvmRegressor
extends AbstractSvmModel
implements Regressor {
    public SvmRegressor() {
        this(LibSvmUtils.parseParameters(""));
    }

    public SvmRegressor(svm_parameter params) {
        super(params);
    }

    private SvmRegressor(svm_model model) {
        super(model);
    }

    public static SvmRegressor deserialize(byte[] modelData) {
        try {
            svm_model model = svm.svm_load_model((BufferedReader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(modelData))));
            return new SvmRegressor(model);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public double regress(FeatureVector features) {
        Objects.requireNonNull(this.model, "model is null");
        return svm.svm_predict((svm_model)this.model, (svm_node[])SvmRegressor.toSvmNodes(features));
    }

    @Override
    public ModelType getType() {
        return RegressorType.REGRESSOR;
    }

    @Override
    protected int getLibsvmType() {
        return 4;
    }
}

