/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import io.trino.plugin.ml.AbstractSvmModel;
import io.trino.plugin.ml.Classifier;
import io.trino.plugin.ml.FeatureVector;
import io.trino.plugin.ml.LibSvmUtils;
import io.trino.plugin.ml.type.ClassifierType;
import io.trino.plugin.ml.type.ModelType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;

public class SvmClassifier
extends AbstractSvmModel
implements Classifier<Integer> {
    public SvmClassifier() {
        this(LibSvmUtils.parseParameters(""));
    }

    public SvmClassifier(svm_parameter params) {
        super(params);
    }

    private SvmClassifier(svm_model model) {
        super(model);
    }

    public static SvmClassifier deserialize(byte[] modelData) {
        try {
            svm_model model = svm.svm_load_model((BufferedReader)new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(modelData), StandardCharsets.UTF_8)));
            return new SvmClassifier(model);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Integer classify(FeatureVector features) {
        Objects.requireNonNull(this.model, "model is null");
        return (int)svm.svm_predict((svm_model)this.model, (svm_node[])SvmClassifier.toSvmNodes(features));
    }

    @Override
    public ModelType getType() {
        return ClassifierType.BIGINT_CLASSIFIER;
    }

    @Override
    protected int getLibsvmType() {
        return 0;
    }
}

