/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.trino.plugin.mongodb.ReadPreferenceType;
import io.trino.plugin.mongodb.WriteConcernType;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@DefunctConfig(value={"mongodb.connection-per-host"})
public class MongoClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter PORT_SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings();
    private String schemaCollection = "_schema";
    private boolean caseInsensitiveNameMatching;
    private List<ServerAddress> seeds = ImmutableList.of();
    private List<MongoCredential> credentials = ImmutableList.of();
    private int minConnectionsPerHost;
    private int connectionsPerHost = 100;
    private int maxWaitTime = 120000;
    private int connectionTimeout = 10000;
    private int socketTimeout;
    private int maxConnectionIdleTime;
    private boolean socketKeepAlive;
    private boolean sslEnabled;
    private int cursorBatchSize;
    private ReadPreferenceType readPreference = ReadPreferenceType.PRIMARY;
    private WriteConcernType writeConcern = WriteConcernType.ACKNOWLEDGED;
    private String requiredReplicaSetName;
    private String implicitRowFieldPrefix = "_pos";

    @NotNull
    public String getSchemaCollection() {
        return this.schemaCollection;
    }

    @Config(value="mongodb.schema-collection")
    public MongoClientConfig setSchemaCollection(String schemaCollection) {
        this.schemaCollection = schemaCollection;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="mongodb.case-insensitive-name-matching")
    public MongoClientConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<ServerAddress> getSeeds() {
        return this.seeds;
    }

    @Config(value="mongodb.seeds")
    public MongoClientConfig setSeeds(String commaSeparatedList) {
        this.seeds = this.buildSeeds(SPLITTER.split((CharSequence)commaSeparatedList));
        return this;
    }

    public MongoClientConfig setSeeds(String ... seeds) {
        this.seeds = this.buildSeeds(Arrays.asList(seeds));
        return this;
    }

    @NotNull
    public List<MongoCredential> getCredentials() {
        return this.credentials;
    }

    @Config(value="mongodb.credentials")
    @ConfigSecuritySensitive
    public MongoClientConfig setCredentials(String credentials) {
        this.credentials = this.buildCredentials(SPLITTER.split((CharSequence)credentials));
        return this;
    }

    public MongoClientConfig setCredentials(String ... credentials) {
        this.credentials = this.buildCredentials(Arrays.asList(credentials));
        return this;
    }

    private List<ServerAddress> buildSeeds(Iterable<String> hostPorts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String hostPort : hostPorts) {
            List values = PORT_SPLITTER.splitToList((CharSequence)hostPort);
            Preconditions.checkArgument((values.size() == 1 || values.size() == 2 ? 1 : 0) != 0, (Object)"Invalid ServerAddress format. Requires host[:port]");
            if (values.size() == 1) {
                builder.add((Object)new ServerAddress((String)values.get(0)));
                continue;
            }
            builder.add((Object)new ServerAddress((String)values.get(0), Integer.parseInt((String)values.get(1))));
        }
        return builder.build();
    }

    private List<MongoCredential> buildCredentials(Iterable<String> userPasses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String userPassDatabase : userPasses) {
            int lastIndex = userPassDatabase.lastIndexOf(64);
            Preconditions.checkArgument((lastIndex > 0 ? 1 : 0) != 0, (Object)"Invalid Credential format. Requires user:password@database");
            String userPass = userPassDatabase.substring(0, lastIndex);
            String database = userPassDatabase.substring(lastIndex + 1);
            int firstIndex = userPass.indexOf(58);
            Preconditions.checkArgument((firstIndex > 0 ? 1 : 0) != 0, (Object)"Invalid Credential format. Requires user:password@database");
            String user = userPass.substring(0, firstIndex);
            String password = userPass.substring(firstIndex + 1);
            builder.add((Object)MongoCredential.createCredential((String)user, (String)database, (char[])password.toCharArray()));
        }
        return builder.build();
    }

    @Min(value=0L)
    public @Min(value=0L) int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Config(value="mongodb.min-connections-per-host")
    public MongoClientConfig setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    @Config(value="mongodb.connections-per-host")
    public MongoClientConfig setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Config(value="mongodb.max-wait-time")
    public MongoClientConfig setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="mongodb.connection-timeout")
    public MongoClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Config(value="mongodb.socket-timeout")
    public MongoClientConfig setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    @Config(value="mongodb.socket-keep-alive")
    public MongoClientConfig setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
        return this;
    }

    @NotNull
    public ReadPreferenceType getReadPreference() {
        return this.readPreference;
    }

    @Config(value="mongodb.read-preference")
    public MongoClientConfig setReadPreference(ReadPreferenceType readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    @NotNull
    public WriteConcernType getWriteConcern() {
        return this.writeConcern;
    }

    @Config(value="mongodb.write-concern")
    public MongoClientConfig setWriteConcern(WriteConcernType writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Config(value="mongodb.required-replica-set")
    public MongoClientConfig setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
        return this;
    }

    public int getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    @Config(value="mongodb.cursor-batch-size")
    public MongoClientConfig setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
        return this;
    }

    @NotNull
    public String getImplicitRowFieldPrefix() {
        return this.implicitRowFieldPrefix;
    }

    @Config(value="mongodb.implicit-row-field-prefix")
    public MongoClientConfig setImplicitRowFieldPrefix(String implicitRowFieldPrefix) {
        this.implicitRowFieldPrefix = implicitRowFieldPrefix;
        return this;
    }

    public boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @Config(value="mongodb.ssl.enabled")
    public MongoClientConfig setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Config(value="mongodb.max-connection-idle-time")
    public MongoClientConfig setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        return this;
    }
}

